package com.duiba.tuia.youtui.web.constant;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.model.rsp.PullDownRsp;
import com.duiba.tuia.youtui.web.tool.PathUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * 下拉推荐位先行测试数据
 * <p/>
 * Created by xuefeng on 2018/1/18.
 */
public class PullDownData {

    private PullDownData() {

    }

    static List<SingleData> list;

    static {
        list = new ArrayList<>();
        list.add(new SingleData(1894l, 5458L, 584L, 1L));
        list.add(new SingleData(1894l, 5460L, 584L, 1L));
        list.add(new SingleData(1894l, 5463L, 584L, 2L));
        list.add(new SingleData(1894l, 5465L, 584L, 2L));
        list.add(new SingleData(1406l, 5445L, 584L, 1L));
        list.add(new SingleData(1406l, 5454L, 584L, 1L));
        list.add(new SingleData(1406l, 5466L, 584L, 2L));
        list.add(new SingleData(1406l, 5468L, 584L, 2L));
    }

    /**
     * 是否出下拉推荐位
     *
     * @param slotId
     * @param activityId
     * @return
     */
    public static int isPullDown(Long slotId, Long activityId) {
        for (SingleData singleData : list) {
            if (singleData.getSlotId().equals(slotId) && singleData.getActivityId().equals(activityId)) {
                return 1;
            }
        }
        return 0;
    }

    public static PullDownRsp getData(IndexReq req) {
        PullDownRsp rsp = new PullDownRsp();
        for (SingleData singleData : list) {
            if (singleData.getSlotId().equals(req.getSlotId()) && singleData.getActivityId().equals(req.getId())) {
                rsp.setStyleId(singleData.getStyleId());
                rsp.setPageId(singleData.getMainMeetId());
                //构建跳转url
                rsp.setUrl(PathUtil.getGuidePageUrl(singleData.getMainMeetId(), req, PageType.MAINMEET.getCode()));
            }
        }
        return rsp;
    }

    static class SingleData {
        private Long slotId;//广告位id
        private Long activityId;//活动id
        private Long mainMeetId;//主会场id
        private Long styleId;//下拉样式id，1：白子板 2：幕布版

        public SingleData(Long slotId, Long activityId, Long mainMeetId, Long styleId) {
            this.slotId = slotId;
            this.activityId = activityId;
            this.mainMeetId = mainMeetId;
            this.styleId = styleId;
        }

        public Long getSlotId() {
            return slotId;
        }

        public void setSlotId(Long slotId) {
            this.slotId = slotId;
        }

        public Long getActivityId() {
            return activityId;
        }

        public void setActivityId(Long activityId) {
            this.activityId = activityId;
        }

        public Long getMainMeetId() {
            return mainMeetId;
        }

        public void setMainMeetId(Long mainMeetId) {
            this.mainMeetId = mainMeetId;
        }

        public Long getStyleId() {
            return styleId;
        }

        public void setStyleId(Long styleId) {
            this.styleId = styleId;
        }
    }
}
