package com.duiba.tuia.youtui.web.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 页面枚举
 *
 * 活动系统可能出现的页面
 */
public enum Page {
    ACTIVITY("/activity/index", "活动页", 1),
    RECORD("/activity/indexRecord", "我的奖品页", 2),
    DIRECT("/direct/index", "直投页", 3),
    ACTCENTER("/actCenter/index", "活动中心页", 4),
    MAINMEET("/mainMeet/index", "主会场", 5),
    //现金钱包，我认为不需要
    GAME("game/index", "游戏", 7),
    ;

    private static Map<String,Page> pages = new HashMap<>();
    static{
        for (Page page : Page.values()) {
            pages.put(page.getPath(), page);
        }
    }
    private String path;
    private String desc;
    private int dsmC;


    Page(String path, String desc, int dsmC) {
        this.path = path;
        this.desc = desc;
        this.dsmC = dsmC;
    }

    public String getPath() {
        return path;
    }

    public String getDesc() {
        return desc;
    }

    public int getDsmC() {
        return dsmC;
    }

    public static String location(String path, String id) {
        Page page = pages.get(path);
        if (page != null) {
            return page.getDsmC() + "." + (StringUtils.isBlank(id) ? "0" : id);
        }
        return null;
    }



}
