/**
 * Project Name:tuia-youtui-web<br>
 * File Name:InsuranceMsgEnum.java<br>
 * Package Name:com.duiba.tuia.youtui.web.constant<br>
 * Date:2017年4月19日下午4:33:53<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package com.duiba.tuia.youtui.web.constant;

import org.apache.commons.lang.StringUtils;


/**
 * ClassName:InsuranceMsgEnum <br/>
 * Function: 保险落地页文案. <br/>
 * Date:     2017年3月2日 下午8:42:48 <br/>
 * 
 * 错误码组成:AAABBB
 * <ul>
 * AAA：落地页id
 * <li>000:共用</li>
 * <li>006:黑牛</li>
 * <li>007:招商</li>
 * </ul>
 * <ul>
 * BBB：内部文案标志
 * </ul>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see      
 */
public enum InsuranceMsgEnum {
    M006001("006001","非常感谢提交信息。","请留意发给您的短信，保险详情以短信通知为准"),
    M006002("006002","恭喜您成功领取{}。","请留意xx发给您的短信，保险详情以短信通知为准"),
    M006003("006003","非常抱歉，由于年龄、地域、重复提交等原因，您的信息未能成功投保。",""),
    
    M007001("007001","非常抱歉，投保年龄要求在18-60周岁。",""),
    M007002("007002","非常抱歉，您已经提交过信息，请不要重复提交。",""),
    M007003("007003","感谢提交，我们将在10个工作日左右，通过短信给您发送电子保单地址。",""),
    M007004("007004","请填写正确的身份证号信息",""),
    
    M023001("023001","请填写验证码",""),
    M023002("023002","短信验证码不正确",""),
    M023003("023003","你已申请{}一份，稍后将有客服人员与您联系，协助办理保险事宜",""),
    
    M000000("","","");
    
    private String code;
    private String message;
    private String tip;

    private InsuranceMsgEnum(String code, String message, String tip) {
        this.code = code;
        this.message = message;
        this.tip = tip;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String getMessage(String restr) {
        if (StringUtils.isBlank(restr)) {
            return message;
        }
        return message.replace("{}", restr);
    }

    public String getTip() {
        return tip;
    }

    public String getTip(String restr) {
        if (StringUtils.isBlank(restr)) {
            return message;
        }
        return tip.replace("{}", restr);
    }
}
