/*
 * 
 */
package com.duiba.tuia.youtui.web.constant;

/**
 * 此类描述的是：简版后台错误码<br>
 * 错误码组成：AABCCCC
 * <ul>
 * AA：模块编号
 * <li>01：模块共用</li>
 * <li>02：活动模块</li>
 * <li>03：奖品模块</li>
 * <li>04：订单数据模块</li>
 * </ul>
 * <ul>
 * B：内外部错误码标志
 * <li>0：内部错误码</li>
 * <li>1：外部错误码</li>
 * </ul>
 * <ul>
 * <ul>
 * CCCC:具体错误码 举例
 * <li>通用的成功状态码：0000000</li>
 * <li>通用的未知错误码：9999999</li>
 * </ul>.
 *
 * @author: zp
 */
public enum ErrorCode {

    /** *** 通用异常：00开头 *****. */
    E0000000("0000000", "成功"),

    /** 发生未知错误. */
    E9999999("9999999", "发生未知错误"),

    /** 无效的参数输入. */
    E0000001("0000001", "无效的参数输入"),

    /** 解密出错. */
    E0000002("0000002", "解密出错"),
    
    /** URLEncode/URLDecode出错. */
    E0000003("0000003", "URLEncode/URLDecode出错"),

    /** ****************** 内部业务错误：01开头 *******************. */

    /** 用户参与次数达到上限. */
    E0100001("0100001", "用户参与次数达到上限"),
    /** 重复发送验证码. */
    E0100002("0100002", "重复发送验证码"),
    /** 非法的短信验证码类型. */
    E0100003("0100003", "非法的短信验证码类型"),
    /** 短信验证码校验失败. */
    E0100004("0100004", "短信验证码校验失败"),
    /** 发送短信验证码失败. */
    E0100005("0100005", "发送短信验证码失败"),
    /** 手机号已注册. */
    E0100006("0100006", "手机号已注册"),
    /** 落地页不存在. */
    E0100007("0100007", "落地页不存在"),
    /** 用户已存在.*/
    E0100008("0100008", "用户已存在"),
    /**密码错误*/
    E0100009("0100009", "密码错误"),
    /**落地页渠道不正确*/
    E0100010("0100010", "落地页渠道不正确"),
    /**字段填写为空*/
    E0100011("0100011", "字段填写为空"),
    /**字符长度大于200*/
    E0100012("0100012", "字段长度大于200"),
    /**字段应为数字格式，长度不可大于20*/
    E0100013("0100013", "字段应为数字格式，长度不可大于20"),

    /** ****************** 用户中心错误：02开头 *******************. */
    /** 查询用户信息失败. */
    E0200001("0200001", "查询用户信息失败"),

    /** 用户不存在. */
    E0200002("0200002", "用户不存在"),
    
    /** 用户未登录，请先登录. */
    E0200003("0200003", "请先登录"),
    
    /** 预览用户不能参与活动. */
    E0200004("0200004", "预览用户不能参与活动"),
    
    /** 用户获取参与结果异常. */
    E0200005("0200005", "用户获取参与结果异常"),

    /** 格式有误，请重新输入. */
    E0200006("0200006", "格式有误，请重新输入"),

    /** 此手机号码尚未注册，先去注册吧. */
    E0200007("0200007", "此手机号码尚未注册，先去注册吧"),

    /** 密码有误，请重新输入 */
    E0200008("0200008", "密码有误，请重新输入"),

    /** 此手机号已注册过，快去登录吧 */
    E0200009("0200009", "此手机号已注册过，快去登录吧"),

    /** 第三方签名校验失败 */
    E0200010("0200010", "请求非法"),

    /** 您已经登录了 */
    E0200011("0200011", "您已经登录了"),

    /** 验证码已经过期，请重新获取 */
    E0200012("0200012", "验证码已经过期，请重新获取"),

    /** 图形验证码校验失败 */
    E0200013("0200013", "图形验证码校验失败"),

    /** 登陆尝试次数太多，您歇歇吧 */
    E0200014("0200014", "登录尝试次数太多，请稍后重试"),

    /** 用户无权调用 */
    E0200015("0200015", "用户无权调用"),
    E0200016("0200016", "当前环境有风险,请稍后再试~"),

    /* 现金钱包提现 */
    E0200017("0200017", "账户余额不足"),

    E0200018("0200018", "登陆类型错误"),

    /** ****************** 开发者中心错误：03开头 *******************. */

    /** 查询应用失败. */
    E0300001("0300001", "查询应用失败"),

    /** appkey不存在. */
    E0300002("0300002", "appkey不存在"),

    /** ****************** 活动中心错误：04开头 *******************. */

    E0400000("0400000","调用tuia-activity-center dubbo 接口异常"),

    /** 查询活动失败. */
    E0400001("0400001", "查询活动失败"),

    /** 查询奖项列表失败. */
    E0400002("0400002", "查询奖项列表失败"),

    /** 奖项概率配置出错. */
    E0400003("0400003", "奖项概率配置出错"),

    /** 活动不存在或者已删除. */
    E0400004("0400004", "活动不存在或者已删除"),

    /** 查询用户参与活动次数失败. */
    E0400005("0400005", "查询用户参与活动次数失败"),

    /** 创建订单失败. */
    E0400006("0400006", "创建订单失败"),

    /** 更新订单失败. */
    E0400007("0400007", "更新订单失败"),

    /** 查询订单失败. */
    E0400008("0400008", "查询订单失败"),

    /** 订单不存在. */
    E0400009("0400009", "订单不存在"),
    
    /** 引导页不存在. */
    E0400010("0400010", "引导页不存在"),
    
    /** 引导页不存在. */
    E0400011("0400011", "引导页皮肤不存在"),
    
    /** 游戏不存在. */
    E0400012("0400012", "游戏不存在"),

    /** 查询插件工具列表失败. */
    E0400013("0400013", "查询插件工具列表失败，无可投插件工具"),

    /** 查询活动中心列表失败. */
    E0400014("0400014", "查询活动中心列表失败"),

    /** 查询插件工具列表失败. */
    E0400015("0400015", "该用户无可出插件"),
    
    /** 查询插件工具皮肤失败或皮肤已删除. */
    E0400016("0400016", "查询插件工具皮肤失败或皮肤已删除"),
    
    /** 查询插件工具皮肤失败或皮肤已删除. */
    E0400017("0400017", "查询插件工具过滤无结果"),
    
    /** 查询插件工具失败或已删除. */
    E0400018("0400018", "查询插件工具失败或已删除"),

    E0400019("E0400019", "广告位插件按钮关闭"),

    E0400020("E0400020", "广告位不正确"),

    E0400021("E0400021","该区域不可出插件"),


    /** ****************** 库存中心错误：05开头 *******************. */

    /** 查询奖品库存失败. */
    E0500001("0500001", "查询奖品库存失败"),

    /** ****************** 应用中心错误：06开头 *******************. */

    /******************** 商品中心错误：07开头 ********************/
    /** 查询广告券信息失败. */
    E0700001("0700001", "查询广告券信息失败"),

    /** ****************** 推啊引擎(core)中心错误：08开头 *******************. */
    /** 查询广告券信息失败. */
    E0800001("0800001", "查询广告券信息失败"),

    /** 查询有效广告信息失败 */
    E0800002("0800002","查询有效广告信息失败"),
    
    /** ****************** tuia-media错误：09开头 *******************. */

    /** 获取活动引擎推荐活动失败. */
    E0900001("0900001", "获取活动引擎推荐活动失败"),
    
    /** 获取广告位配置失败. */
    E0900002("0900002", "获取广告位配置失败"),


    /** ****************** 推啊外部错误错误：010开头 *******************. */

    /** 广告转化落地页必要参数为null. */
    E0110001("0110001", "必要参数不可为空"),

    /** 必要参数不可为空  a_tuiaid 必填. */
    E0110002("0110002", "Required param a_tuiaid Missing"),

    /** 必要参数不可为空  a_cid 必填. */
    E0110003("0110003", "Required param a_cid Missing"),

    /** 必要参数不可为空  a_timeStamp 必填. */
    E0110004("0110004", "Required param a_timeStamp Missing"),

    /** 必要参数不可为空  ip 必填. */
    E0110005("0110005", "Required param ip Missing"),

    /** 签名失败  signature 必填. */
    E0110006("0110006", "signature fail"),

    /** 必要参数类型不可为空  type 必填. */
    E0110007("0110007", "Required param type Missing"),

    /** 必要参数不可为空  signature 必填. */
    E0110008("0110008", "Required param signature Missing"),

    /* 零钱奖励异常 */
    E0111002("0110002", "用户超过每日限制次数"),
    E0111003("0110003", "活动超过每日限制金额"),

    /** doJoin 和 result 错误码返回    start  --2018-01-31 */
    E0120001("0120001", "退出再回来有惊喜哟!"),
    E0120002("0120002", "就差一点点，再来一次吧!"),
    E0120003("0120003", "就差一点点，再来一次吧!"),
    E0120004("0120004", "请刷新一下哟!"),
    E0120005("0120005", "系统开小差啦!"),
    E0120006("0120006", "请刷新一下哟!"),
    E0120007("0120007", "系统开小差啦!"),
    E0120008("0120008", "系统开小差啦!"),
    E0120009("0120009", "系统开小差啦!"),
    E0120010("0120010", "系统开小差啦!"),
    E0120011("0120011", "系统开小差啦!"),
    E0120012("0120012", "系统开小差啦!"),
    /** doJoin 和 result 错误码返回    end  --2018-01-31 */

    /** 瓜分红包错误 */
    E0120013("0120013", "该红包还未开奖!");


    /** The e code. */
    private String eCode;

    /** The e desc. */
    private String eDesc;

    /**
     * Creates a new instance of ErrorCode.
     *
     * @param eCode the e code
     * @param eDesc the e desc
     */
    private ErrorCode(String eCode, String eDesc) {
        this.eCode = eCode;
        this.eDesc = eDesc;
    }

    /**
     * Gete code.
     *
     * @return the e code
     */
    public String geteCode() {
        return eCode;
    }

    /**
     * Gete desc.
     *
     * @return the e desc
     */
    public String geteDesc() {
        return eDesc;
    }
}
