package com.duiba.tuia.youtui.web.constant;

import org.apache.commons.lang.StringUtils;

/**
 * cookie整理后，将所有的_g_actId_dcm,_plu_pluId_dsm,_g_actId_dpm等进行整合
 * @author lichao 2018/4/2
 */
public class DmCookieHolder {


    private static final String split = "\\^";

    private String dsm;
    private String dcm;
    private String dpm;
    private String objectId;
    private long currentTime;//当前时间

    public static DmCookieHolder build(String value){
        if(StringUtils.isBlank(value)){
            return null;
        }
        String[] values = value.split(split);
        if(values.length!=5){
            return null;
        }
        return new DmCookieHolder(values[0],values[1],values[2],values[3]
                ,StringUtils.isNotBlank(values[4])?Long.valueOf(values[4]):0L);
    }

    public String buildString(){
        StringBuilder sb = new StringBuilder(objectId);
        sb.append("^").append(dsm)
                .append("^").append(dcm)
                .append("^").append(dpm)
                .append("^").append(currentTime);
        return sb.toString();
    }

    public DmCookieHolder(String objectId, String dsm, String dcm, String dpm, long currentTime) {
        this.dsm = dsm;
        this.dcm = dcm;
        this.dpm = dpm;
        this.objectId = objectId;
        this.currentTime = currentTime;
    }

    public String getDsm() {
        return dsm;
    }

    public void setDsm(String dsm) {
        this.dsm = dsm;
    }

    public String getDcm() {
        return dcm;
    }

    public void setDcm(String dcm) {
        this.dcm = dcm;
    }

    public String getDpm() {
        return dpm;
    }

    public void setDpm(String dpm) {
        this.dpm = dpm;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public long getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }
}
