package com.duiba.tuia.youtui.web.constant;

import java.util.Arrays;
import java.util.List;

import com.google.common.collect.ImmutableSet;

/**
 * ClassName: AppIdConstant <br/>
 * date: 2016年12月5日 下午7:28:49 <br/>.
 *
 * @since JDK 1.6
 */
public class AppIdConstant {

	/** ** 手工客APPID. */
	private static final List<Long> isShouGongKe = Arrays.asList(10241L);

	/** The Constant DownloadUrlToTextList. */
	private static final List<Long> DownloadUrlToTextList = Arrays.asList(4515L, 5183L, 4688L, 4714L, 2516L, 4437L, 6839L, 5965L, 4786L, 9438L, 8786L, 10935L, 11150L, 7433L, 15160L, 16101L, 12091L, 17509L);

	/**
	 * 下载链接在展示的时候，个别app中需要展示纯文本.
	 *
	 * @param appId the app id
	 * @return true, if checks if is download url show text
	 */
	public static boolean isDownloadUrlShowText(Long appId) {
		return DownloadUrlToTextList.contains(appId);
	}

	/** The Constant ganjiShowMoreHistory. */
	private static final ImmutableSet<Long> ganjiShowMoreHistory = ImmutableSet.of(2264L, 2064L);


	/**
	 * 在兑换记录页最下面的 “已经没有更多了！”替换成app的链接
	 * 目前是赶集网的需求.
	 *
	 * @param appId the app id
	 * @return true, if checks if is ganji show more history
	 */
	public static boolean isGanjiShowMoreHistory(Long appId) {
		return ganjiShowMoreHistory.contains(appId);
	}

	/** qq浏览器 fxt 2016-03-14. */
	private static final ImmutableSet<Long> qqBrowserList = ImmutableSet.of(9454L, 9505L);

	/**
	 * 判断是否是qq浏览器.
	 *
	 * @param appId the app id
	 * @return true, if checks if is qq browser list
	 */
	public static boolean isQqBrowserList(Long appId) {
		return qqBrowserList.contains(appId);
	}

	/**
	 * The Constructor.
	 */
	private AppIdConstant() {
	}

	/**
	 * Checks if is shou gong ke.
	 *
	 * @param appId the app id
	 * @return true, if checks if is shou gong ke
	 */
	public static boolean isShouGongKe(Long appId) {
		return isShouGongKe.contains(appId);
	}
	/** 兑吧优惠券在兑换成功后，兑换成功通知页、领奖成功通知页、兑换记录详情页是否展示马上使用的按钮 赶集:2264L,2064L ||  58同城:4515   ||  PPTV:4688 || 360手机助手:10935. */
	public static final ImmutableSet<Long> showUseButton = ImmutableSet.of(2264L, 2064L, 4515L, 5183L, 4688L, 2516L,
			4437L, 6839L, 4786L, 9438L, 8786L, 10935L,
			11150L, 7433L, 15160L);

}
