
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityBO.java<br>
 * Package Name:com.duiba.tuia.youtui.web.bo<br>
 * Date:2017年1月17日下午4:15:57<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.bo;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;

import javax.servlet.http.HttpServletRequest;


/**
 * ClassName: ActivityBO <br/>
 * Function: 参与活动业务编排. <br/>
 * date: 2017年1月17日 下午4:15:57 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public interface JoinActivityBO {
    /**
     * 参与活动.
     *
     * @param doJoinActivityReq the do join activity req
     * @throws ActivityException the activity exception
     */
    JSONObject doJoin(HttpServletRequest request,DoJoinActivityReq doJoinActivityReq)throws ActivityException;
    
    /**
     * result:获取活动结果. <br/>
     *
     * @author cdm
     * @param request
     * @param activityOrderId   活动订单ID
     * @return
     * @since JDK 1.7
     */
    JSONObject result(HttpServletRequest request, String activityOrderId,Boolean showVersion) throws ActivityException;
}

