/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityBO.java<br>
 * Package Name:com.duiba.tuia.youtui.web.bo<br>
 * Date:2017年1月24日下午2:54:24<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.bo;

import cn.com.duiba.tuia.activity.center.api.constant.EntranceType;
import cn.com.duiba.tuia.activity.center.api.dto.LayerSkinDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProbDto;
import cn.com.tuia.advert.model.SpmlogReq;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.exception.BusinessException;
import com.duiba.tuia.youtui.web.model.RecordDetailVO;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.req.*;
import com.duiba.tuia.youtui.web.model.rsp.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * ClassName: ActivityBO <br/>
 * Function: 活动业务编排. <br/>
 * date: 2017年1月24日 下午2:54:24 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface ActivityBO {

    /**
     * 获取活动皮肤配置.
     *
     * @param req the req
     * @param request the request
     * @return the activity skin config
     * @throws ActivityException the activity exception
     */
    GetSkinConfigRsp getActivitySkinConfig(ActivitySkinReq req,HttpServletRequest request) throws ActivityException, ExecutionException;

    /**
     * 获取广告信息.
     *
     * @param req the req
     * @param consumer the consumer
     * @param request  the request
     * @return the prize detail
     * @throws ActivityException the activity exception
     */
    PrizeDteailRsp getPrizeDetail(PrizeReq req, UserAccount consumer,HttpServletRequest request) throws ActivityException;

    /**
     * getActivityOption:(获取活动的相关配置信息). <br/>
     *
     * @param req the req
     * @param request the request
     * @return the activity option
     * @throws ActivityException the activity exception
     * @author wubo
     * @since JDK 1.7
     */
    ActivityOptionRsp getActivityOption(ActivityOptionReq req,HttpServletRequest request) throws ActivityException;

    /**
     * 获取活动中奖次数接口
     *
     * @param req
     * @return
     * @throws ActivityException
     */
    ActivityLimitTimesRsp getLimitTimes(ActivityOptionReq req) throws ActivityException ;

    /**
     * 获取用户兑换记录列表.
     *
     * @param req the req
     * @param consumer the consumer
     * @param request the request
     * @return the record list
     * @throws ActivityException the activity exception
     */
    PrizeRecordsRsp getRecordList(OptionListReq req, UserAccount consumer,HttpServletRequest request) throws ActivityException;

    /**
     * 过去兑换记录详情.
     *
     * @param orderId the order id
     * @param consumer the consumer
     * @param request the request
     * @return the record
     * @throws ActivityException the activity exception
     */
    RecordDetailVO getRecord(String orderId, UserAccount consumer,HttpServletRequest request) throws ActivityException;

    /**
     * 初始化活动页.
     *
     * @param req the req
     * @param consumer the consumer
     * @param request the request
     * @return the model and view
     * @throws ActivityException the activity exception
     */
    ModelAndView index(IndexReq req, UserAccount consumer, HttpServletRequest request) throws ActivityException, ExecutionException, BusinessException;


    /**
     * 初始化iframe活动页.
     *
     * @param req the req
     * @param consumer the consumer
     * @param request the request
     * @return the model and view
     * @throws ActivityException the activity exception
     */
    ModelAndView iframeIndex(IndexReq req, UserAccount consumer, HttpServletRequest request) throws ActivityException;

    /**
     * 初始化兑换记录页面.
     *
     * @param vmName the vm name
     * @return the model and view
     * @throws ActivityException the activity exception
     */
    ModelAndView indexRecord(String vmName,HttpServletRequest request) throws ActivityException;

    /**
     * 点击日志.
     *
     * @param req the req
     * @return true, if spm click log
     * @throws ActivityException the activity exception
     */
    void clickLog(SpmlogReq req) throws ActivityException;

    /**
     * 曝光日志.
     *
     * @param req the req
     * @return true, if show log
     * @throws ActivityException the activity exception
     */
    void showLog(SpmlogReq req) throws ActivityException;

    /**
     * Tuia log process.
     *
     * @param req the req
     * @param request the request
     * @return the web show click log req
     * @throws ActivityException the activity exception
     */
    void tuiaLogProcess(WebShowClickLogReq req, HttpServletRequest request) throws ActivityException;

    /**
     * Tuia direct process.
     *
     * @param req the req
     * @param request the request
     * @return the web show click log req
     * @throws ActivityException the activity exception
     */
    void tuiaDirectProcess(WebShowClickLogReq req, HttpServletRequest request) throws ActivityException;

    /**
     * budilSpmlogReq:构建日志请求参数 . <br/>
     *
     * @param req the req
     * @param request 请求
     * @return the spmlog req
     * @throws ActivityException the activity exception
     * @author cdm
     * @since JDK 1.7
     */
    SpmlogReq budilSpmlogReq(WebShowClickLogReq req, HttpServletRequest request) throws ActivityException;

    /**
     * Url filter.
     *
     * @param request
     * @param url the URL
     * @param orderId the order id
     * @param consumerId
     * @return the string
     * @throws ActivityException the activity exception
     */

    String urlFilter(HttpServletRequest request,String url, String orderId, String consumerId) throws ActivityException;

    /**
     * updateReturnTimes:(更新用户返回拦截跳转次数接口). <br/>
     *
     * @author youhaijun
     * @param slotId
     * @param request
     * @return
     * @since JDK 1.7
     */
    Boolean updateReturnTimes(Long slotId, HttpServletRequest request) throws ActivityException;

    /**
     * getReturnPage:(获取返回拦截跳转去向接口). <br/>
     *
     * @return
     */
    UrlRsp getReturnPage(IndexReq req) throws ActivityException, UnsupportedEncodingException;

    /**
     * getRecommend:(获取活动推荐位信息接口). <br/>
     *
     * @author youhaijun
     * @param req
     * @param request
     * @return
     * @since JDK 1.7
     */
    RecommendRsp getRecommend(RecommendReq req, HttpServletRequest request) throws ActivityException;

    /**
     * getRecommend:(获取非活动推荐位信息接口). <br/>
     *
     * @author youhaijun
     * @param req
     * @param request
     * @return
     * @since JDK 1.7
     */
    RecommendRsp getCloseRecommend(RecommendReq req, HttpServletRequest request) throws ActivityException;

    /**
         * @Description: getBuoy 获取浮标
         *
         * @Param: [req, request]
         * @Return: com.duiba.tuia.youtui.web.model.rsp.BuoyRsp
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/14
         */
    BuoyRsp getBuoy(IndexReq req, HttpServletRequest request) throws ActivityException, ExecutionException;

    /**
     * 查询所有类型的弹层皮肤
     *
     * @return list layerSkinDto
     */
    List<LayerSkinDto> getAllLayerSkin(SkinReq req, HttpServletRequest request);

    KefuResponse getKefu(Long slotId ,HttpServletRequest request) throws ExecutionException,ActivityException;

    /**
     * 获取支付宝红包中奖信息
     *
     * @return
     */
    List<AlipayWinInfoRsp> getAlipayWinInfo();

    /**
     * 获取真实中奖信息
     *
     * @return
     */
    List<AlipayWinInfoRsp> getRealWinInfo(Long id);


    /**
     * 过滤主会场上活动包含广告位标签
     */
    ProbDto filterGuidePageByTag(Long slotId, EntranceType entranceType) throws ActivityException;

    /**
     * 中奖公示
     *
     * @param id
     * @param consumer
     * @param request
     * @return
     */
    PublicNoticeRsp publicNotice(Long id, UserAccount consumer, HttpServletRequest request);

    /**
     * 中奖公示
     *
     * @param id
     * @return
     */
    PublicNoticeRsp publicNoticePriviewData(Long id);

    /**
     * 获取下拉推荐位数据
     *
     * @param req
     * @return
     */
    PullDownRsp getPullDown(IndexReq req, HttpServletRequest request) throws ActivityException;
}
