package com.duiba.tuia.youtui.web.biz.land.param;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.model.req.LandUserInfo;
import com.duiba.tuia.youtui.web.tool.DESUtil;
import com.duiba.tuia.youtui.web.tool.Environment;
import com.duiba.tuia.youtui.web.tool.RSAUtil;

@Component
public class PhoneLoanParam implements LandParamI {

	private static final String SJD_RSA_PUBLICKEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB"
			+ "gQC8K7T84gTf0E1dIH1rB1KrzlEC/rtThdD8hzfS+hYzilY6YzQ7/umsXmpYnsxV"
			+ "Pqcva0LKod4/rAJbfwFBG+LAGEZoDtm4HFt8CaPIKCt2c81LlJo9r4wtodLTgIpf"
			+ "4AL0A0VT3rA0RJVD7563aiJYdCA9VEYuTqw56cQKsl8PbQIDAQAB";
	
	@Override
	public Map<String, Object> getRequestParam(LandUserInfo info) {
		String key = "4abf73c8";
		Map<String, Object> map = new HashMap<>();
		map.put("channel", "tuia-llcs");
		map.put("merchantId", "201703270763");
		String reqData = getReqData(info, key);
		map.put("reqData", reqData);
		map.put("sign", getSign(reqData));
		map.put("key", getKey(key));
		map.put("token", getToken());
		return map;
	}

	@Override
	public String getRequestUrl(LandUserInfo info) {
		// http://m.mobp2p.com/union/login 生产环境域名
		// http://116.228.32.182:7070/wap/union/login 测试环境域名
		if(Environment.isOnline()){
			return "http://m.mobp2p.com/union/login";
		}else{
			return "http://116.228.32.182:7070/wap/union/login";
		}
	}

	private String getReqData(LandUserInfo info, String key){
		JSONObject json = new JSONObject();
		json.put("phone", info.getUserPhone());
		String text = json.toJSONString();
		return DESUtil.encryt(text, key);
	}
	
	private String getSign(String reqData){
		return RSAUtil.signByTuia(reqData);
	}
	
	private String getKey(String key){
		return RSAUtil.encryptByPublicKey(key, SJD_RSA_PUBLICKEY);
	}
	
	private String getToken(){
		return "1234567890";
	}
	
}
