package com.duiba.tuia.youtui.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributesModelMap;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;


/**
 * Created by suyuanlong on 16/8/16.
 */
//@Profile({"dev","test"})//只开发和测试下开启Swagger
@Configuration
@EnableSwagger2
public class SwaggerConfig {
    @Value("${taw.environment}")
    private String environment;

    /**
     *
     * @return
     */
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo()).ignoredParameterTypes(Map.class, ModelMap.class, RedirectAttributesModelMap.class)
                .enable(!"prepub".equals(environment) && !"online".equals(environment))//生产环境禁用。
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.duiba.tuia.youtui.web.controller"))
                .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
                .apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
                .paths(PathSelectors.any())
                .build();
    }


    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("活动web Api文档")
                .description("活动web Api文档")
                .termsOfServiceUrl("")
                .contact("xhf@duiba.com.cn").version("1.0").license("兑吧@2016").build();
    }
}
