package com.duiba.tuia.youtui.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableDuibaFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * Created by suyuanlong on 16/6/24.
 * <p/>
 * 活动中心 门户接入系统。
 * 1：本系统不进行数据库连接
 * 2：本系统不对外提供接口。
 * 3：本系统用velocity模板引擎。
 * 4：所有交互都用dubbo接口进行。
 */
@Configuration
@SpringBootApplication
@EnableDiscoveryClient
@EnableCircuitBreaker
@EnableDuibaFeignClients(basePackages = {"cn.com.duiba.tuia.activity", "cn.com.tuia.advert.service", "cn.com.duiba.stock", "cn.com.duiba.goods", "cn.com.duiba.tuia.ssp", "cn.com.duiba.intersection", "cn.com.duiba.dayu"})
@ImportResource("classpath*:spring/spring-core.xml")
public class Application extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(Application.class);
    }

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		ConfigurableApplicationContext ctx = null;
		try {
		    long start = System.currentTimeMillis();

			SpringApplication sa = new SpringApplication(Application.class);
			ctx = sa.run(args);
			long period = System.currentTimeMillis() - start;
            log.error("tuia-youtui-web start successfully in {} s.", period / 1000.0);
            
			Thread.sleep(Long.MAX_VALUE);
		} catch (Exception e) {
			log.error("tuia-youtui-web start error :", e);
			System.exit(-1);
		} finally {
			if (ctx != null) {
				ctx.close();
			}
		}
	}
}
