package com.duiba.tuia.youtui.web.tool;

import java.util.*;

import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * The Class StringTool.
 */
public class StringTool {

    /**
     * The Constructor.
     */
    private StringTool() {
    }

    private static final String COMMA=",";

    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>.
     *
     * @param arrayStr the array str
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(COMMA);
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>，此处symbol为",".
     *
     * @param arrayStr the array str
     * @param symbol 字符串分隔符
     * @return the long list by str
     */
    public static List<Long> getLongListByStr(String arrayStr, String symbol) {
        if (StringUtils.isBlank(arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(symbol);
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isEmpty(s) || " ".equals(s)) {
                continue;
            }
            list.add(Long.valueOf(s));
        }
        return list;
    }

    /**
     * list转成String.<br>
     * 分隔符为","
     * 
     * @param list the list
     * @return the string by list
     */
    public static String getStringByList(Collection list) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (Object str : list) {
                builder.append(str);
                builder.append(COMMA);
            }

            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * string 转成List<String>.<br>
     * 分隔符为","
     * 
     * @param arrayStr the array str
     * @return the string list by str
     */
    public static List<String> getStringListByStr(String arrayStr) {

        if (!StringUtils.isBlank(arrayStr)) {
            String[] array = arrayStr.split(COMMA);

            List<String> list = new ArrayList<>();
            list.addAll(Arrays.asList(array));
            return list;
        } else {
            return Collections.emptyList();
        }

    }

    /**
     * 判断 逗号分隔的id串中是否包含目标id
     * @param commaStr 逗号分隔字符串
     * @param id 目标id
     * @return boolean
     */
    public static boolean isContainFromCommaStr(String commaStr,Long id) {
        return StringUtils.isNotBlank(commaStr) && appendComma(commaStr).contains(appendComma(id));

    }

    /**
     * 在字符两边拼逗号
     * @param string string
     * @return ,string,
     */
    private static String appendComma(Object string) {
        return COMMA + string + COMMA;
    }

    /**
     * 从逗号分隔，冒号键值对的字符中获取hash map
     * 一般指 id:数量
     * k1:v1,k2:v2
     * @param str str
     * @return Map (id:数量)
     */
    public static Map<Long, Integer> getMapFromStr(String str) {
        Map<Long,Integer> map = Maps.newHashMap();
        if (StringUtils.isNotBlank(str)) {
            String[] strs = str.split(COMMA);
            for (String temp : strs) {
                String[] temps = temp.split(":");
                if (temps.length >= 2) {
                    map.put(Long.parseLong(temps[0]), Integer.parseInt(temps[1]));
                }
            }
        }
        return map;
    }

}
