package com.duiba.tuia.youtui.web.service;/**
 * Created by chengdeman .
 * 17/5/12 .
 */

import javax.servlet.http.HttpServletRequest;

import cn.com.duiba.tuia.activity.center.api.constant.PluginType;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityPluginDto;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.exception.BusinessException;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;
import com.duiba.tuia.youtui.web.model.req.PluginToolsReq;
import com.duiba.tuia.youtui.web.model.rsp.PluginToolsRsp;

import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * 插件工具service
 *
 * @param
 * @author chengdeman
 * @create 2017-05-12 上午9:54
 **/
public interface PluginToolsService {


    /**
     * @Description : 插件工具首页信息
     * @param :  req  请求对象
     * @return :  JSONObject  返回json结果
     * @author :  cdm
     * @since JDK 1.8
     */
    PluginToolsRsp pluginToolsIndex(PluginToolsReq req) throws ActivityException, BusinessException, ExecutionException;


    /**
     * 嵌入式插件活动
     * @param req 请求参数
     * @return rsp
     */
    PluginToolsRsp embeddedIndex(PluginToolsReq req) throws ActivityException, BusinessException;

    /**
     * 参与插件工具.
     *
     * @author  cdm
     * @param doJoinActivityReq the do join Plugin Tools req
     * @throws ActivityException the activity exception
     * @since JDK 1.8
     */
    com.alibaba.fastjson.JSONObject doJoin(DoJoinActivityReq doJoinActivityReq, HttpServletRequest request)throws ActivityException;


    /**
     * result:获取插件工具结果. <br/>
     *
     * @author cdm
     * @param request
     * @param pluginToolsOrderId   插件工具订单ID
     * @return
     * @since JDK 1.8
     */
    JSONObject result(HttpServletRequest request, String pluginToolsOrderId,Boolean showVersion) throws ActivityException;
    
    
    /**
     * 更新用户已经参与过的插件工具ID列表缓存.
     *
     * @param pluginToolsId 用户已经参与过的插件工具ID
     * @param consumerId the consumer id
     * @throws ActivityException the activity exception
     */
    void updateFinishedPluginIdList(HttpServletRequest request,Long pluginToolsId, Long consumerId) throws ActivityException;

    /**
     * 响应式插件
     * @param req req
     * @return
     * @throws ActivityException
     */
    PluginToolsRsp responsiveIndex(PluginToolsReq req) throws ActivityException, BusinessException, ExecutionException;

    /**
     * 定时插件
     * @param req joinTimes 表示关闭的插件(出插件后)
     * @return
     * @throws ActivityException
     */
    PluginToolsRsp timingIndex(PluginToolsReq req) throws ActivityException, BusinessException, ExecutionException;

    /**
     * 根据插件类型，查询当前时间点可出的插件
     * 支持类型：定时插件
     * @param pluginType
     * @return dto
     */
    List<ActivityPluginDto> selectAvailablePluginByMinuteAndType(PluginType pluginType) throws ActivityException;

    /**
     * 根据id 查询
     * @param id 插件id
     * @return 插件
     */
    ActivityPluginDto selectById(Long id) throws ExecutionException;

    /**
     * 根据ids 查询
     *
     * @param ids
     * @return
     */
    List<ActivityPluginDto> selectAvailablePluginByIds(List<Long> ids);

}
