package com.duiba.tuia.youtui.web.service;/**
 * Created by chengdeman .
 * 17/9/13 .
 */

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.AdvertEffectReq;
import com.duiba.tuia.youtui.web.model.req.InnerLogReq;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

/**
 * 记录落地页回传，广告转化等日志信息
 *
 * @param
 * @author chengdeman
 * @create 2017-09-13 上午11:43
 **/
@Service
public interface LogService {


    /**
     * 落地页日志
     * @param req
     * @param request
     * @throws ActivityException
     */
    void landPageLog(InnerLogReq req,HttpServletRequest request) throws ActivityException;

    /**
     * 所有的落地页日志，type ＝49 ，50 的
     * @param req
     * @param request
     * @throws ActivityException
     */
    void allLandPageLog(InnerLogReq req,HttpServletRequest request) throws ActivityException;


    /**
     * 广告转化效果上报
     * @param request
     * @param advertEffectReq  广告转化传入对象
     * @return
     * @throws ActivityException
     */
    JSONObject advertEffect(HttpServletRequest request, AdvertEffectReq advertEffectReq) throws ActivityException;
}
