package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.dto.GameConfigDto;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteGameService;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.GlobalDomainInfoDto;
import cn.com.duiba.tuia.ssp.center.api.remote.RemoteSystemConfigService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Service
public class GameCacheService extends BaseService{

    @Autowired
    private RemoteGameService remoteGameService;

    @Autowired
    private RemoteSystemConfigService remoteSystemConfigService;

    @Autowired
    private cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteSystemConfigService remoteActSystemConfigService;


    private CacheLoader<Long, Optional<GameConfigDto>> gameConfigDtoCacheLoader = new CacheLoader<Long,
            Optional<GameConfigDto>>() {
        @Override
        public Optional<GameConfigDto> load(Long gameId) {
            return Optional.ofNullable(remoteGameService.selectGame(gameId));
        }
    };

    private LoadingCache<Long, Optional<GameConfigDto>> gameConfigDtoCache = CacheBuilder.newBuilder()
            .concurrencyLevel(20).refreshAfterWrite(30,
                    TimeUnit.SECONDS).expireAfterWrite(60,
                    TimeUnit.SECONDS).build(gameConfigDtoCacheLoader);

    private LoadingCache<String, Optional<String>> systemConfigCache = CacheBuilder
            .newBuilder().concurrencyLevel(20).refreshAfterWrite(60, TimeUnit.SECONDS)
            .expireAfterWrite(30, TimeUnit.SECONDS).build(new CacheLoader<String, Optional<String>>() {
                @Override
                public Optional<String> load(String tuiaKey) throws Exception {
                    DubboResult<String> stringDubboResult = remoteActSystemConfigService.selectByKey(tuiaKey);
                    if (stringDubboResult.isSuccess()) {
                        return Optional.ofNullable(stringDubboResult.getResult());
                    } else {
                        return Optional.ofNullable(null);
                    }
                }
            });


    private CacheLoader<Long, Optional<GlobalDomainInfoDto>> gameUrlCacheLoader = new CacheLoader<Long,
            Optional<GlobalDomainInfoDto>>() {
        @Override
        public Optional<GlobalDomainInfoDto> load(Long gameId) {
            return Optional.ofNullable(remoteSystemConfigService.selectGlobalDomainInfo().getResult());
        }
    };

    private LoadingCache<Long, Optional<GlobalDomainInfoDto>> gameUrlCache = CacheBuilder.newBuilder()
            .concurrencyLevel(20).refreshAfterWrite(30,
                    TimeUnit.SECONDS).expireAfterWrite(60,
                    TimeUnit.SECONDS).build(gameUrlCacheLoader);

    public GameConfigDto getGameConfigDto(Long id) {
        if (id == null) {
            return null;
        }
        try {
            Optional<GameConfigDto> optionalDto = gameConfigDtoCache.get(id);
            return optionalDto.orElse(null);
        } catch (Exception e) {
            logger.warn("get gameId error, id=[{}]", id);
        }
        return null;
    }

    public String getGameUrl() {
        try {
            Optional<GlobalDomainInfoDto> optionalDto = gameUrlCache.get(0L);
            return optionalDto.orElseGet(GlobalDomainInfoDto::new).getGameUrl();
        } catch (Exception e) {
            logger.warn("get game url error");
        }
        return "";
    }

    public String getGameLoginBgUrl() {
        try {
            return systemConfigCache.get("tuia_game_login_bg_url").orElse(null);
        } catch (Exception e) {
            logger.warn("get game url error");
        }
        return "";
    }


}
