/**
 * Project Name:tuia-youtui-web<br>
 * File Name:CommonService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年5月3日下午2:52:15<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.Scene;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityOptionDto;
import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.exception.ActivityException;

import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

/**
 * ClassName: CommonService <br/>
 * Function: 公共服务. <br/>
 * Reason: 公共逻辑. <br/>
 * date: 2017年5月3日 下午2:52:15 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
public interface CommonService {

    String getSystemConfig(String key);

    /**
     * checkEffective:(检验请求的有效性). <br/>
     * 对于一段时间内,某些参数相同的请求 认为是无效的
     *
     * @param seconds 时间（秒）
     * @param biz 业务标识
     * @param params 参数...
     * @return true:有效，false:无效
     * @throws UnsupportedEncodingException
     * @throws NoSuchAlgorithmException
     */
    boolean checkEffective(int seconds, String biz, String... params);


    /**
     * 参与次数校验.
     *
     * @param activityId 活动id
     * @param consumerId 用户id
     * @param limitCount 领取限制次数 =null时候不走参与次数校验
     * @param scene 应用场景
     * @return int 参与次数，包含当前次
     * @throws ActivityException the activity exception
     */
    int checkConsumer(Long activityId, Long consumerId, Integer limitCount, Scene scene)
            throws ActivityException;



    /**
     * 构建抽奖结果.
     *
     * @return the JSON object
     * @throws ActivityException the activity exception
     */
    JSONObject queryJoinResultRsp(HttpServletRequest request, String orderId, Long appId, Long ConsumerId, Boolean showVersion) throws ActivityException;

    /**
     * 获取订单号
     * 时间戳(13)+serverId(3)+自赠数(2)
     * 18位
     *
     * @param biz
     * @return
     */
    String getNextOrderId(String biz);


    /**
     * 获取谢谢参与的广告推荐
     *
     * @param consumerId
     * @return
     * @throws ActivityException
     */
    Map<String, Object> getThankRecommend(Long consumerId, HttpServletRequest request) throws ActivityException;

    void doJoin(RspOrder rspOrder, DoJoinActivityReq doJoinActivityReq, List<ActivityOptionDto> options);

}
