package com.duiba.tuia.youtui.web.service;

import cn.com.tuia.advert.model.AdvertDirectDto;
import cn.com.tuia.advert.model.DirectAdvertLogReq;

import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;

import java.util.List;

/**
 * 广告相关服务
 */
public interface AdvertService {

    /**
     * 获取有效的广告
     * @param advertIds 广告ids
     * @return 广告dtos
     * @throws ActivityException
     */
    List<AdvertDirectDto> getValidAdverts(List<Long> advertIds) throws ActivityException;

    /**
     * 直投广告 日志
     * @param req 请求参数
     */
    void directAdvertLog(DirectAdvertLogReq req);

    /**
     * 获取有效的广告(2期接口)
     * @param req req
     * @return 广告dtos
     * @throws ActivityException
     */
    List<AdvertDirectDto> getValidAdverts(DirectPageReq req,List<Long> advertIds) throws ActivityException;

    String getAdvertTimes(Long advertId);
}
