/**
 * Project Name:tuia-youtui-web<br>
 * File Name:ActivityOrderService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年2月4日下午5:01:58<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.dto.ActivityOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp;
import cn.com.duiba.tuia.activity.center.api.dto.CouponsCodeDto;
import cn.com.duiba.tuia.activity.center.api.dto.OptionDto;
import cn.com.duiba.tuia.activity.center.api.dto.PrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.RechargeQBRsp;
import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import cn.com.duiba.tuia.activity.center.api.dto.TuiaActivityDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqAliOrderQuery;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDto;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.req.AlipayReq;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;
import com.duiba.tuia.youtui.web.model.req.PhysicalReq;
import com.duiba.tuia.youtui.web.model.req.RechargeQBReq;
import com.duiba.tuia.youtui.web.model.req.VirtualWinnerReq;

import java.util.List;

/**
 * ClassName: ActivityOrderService <br/>
 * Function: 活动订单. <br/>
 * date: 2017年2月4日 下午5:01:58 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface ActivityOrderService {

    /**
     * 创建订单.
     *
     * @param doJoinActivityReq the do join activity req
     * @param activityDto the activity dto
     * @return the long
     * @throws ActivityException the activity exception
     */
    RspOrder createOrder(DoJoinActivityReq doJoinActivityReq,TuiaActivityDto activityDto) throws ActivityException;

    /**
     * 为 直投广告 创建活动订单.
     * @param doJoinActivityReq
     * @return
     * @throws ActivityException
     */
    RspOrder createOrderForDirectPage(DoJoinActivityReq doJoinActivityReq)throws  ActivityException;

    /**
     * 更新订单状态(中谢谢参与时使用).
     *
     * @param orderId 订单id
     * @param consumerId 用户id
     * @param option the option
     * @throws ActivityException the activity exception
     */
    void updateOrderOfOptionThanks(String orderId, Long consumerId, OptionDto option)
                                                                                                      throws ActivityException;

    /**
     * 更新订单状态(中实物奖品时使用).
     *
     * @param orderId 订单id
     * @param consumerId 用户id
     * @param option the option
     * @throws ActivityException the activity exception
     */
    void updateActivityOrderOfPrize(String orderId, Long consumerId, OptionDto option , PrizeDto prizeDto) throws ActivityException;


    Integer createPhysicalOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq, PrizeDto prizeDto);


    Integer createAlipayOrder(String orderId, OptionDto option, int amount ,DoJoinActivityReq doJoinActivityReq);

    Integer createQBOrder(String orderId, OptionDto option, int amount ,DoJoinActivityReq doJoinActivityReq,PrizeDto prizeDto);

    /**
     * 创建支付宝订单
     * @param orderId 订单id
     * @param option 奖项
     * @param amount 金额
     * @param doJoinActivityReq 请求参数
     * @return
     */
    Integer createBillOrder(String orderId,OptionDto option,int amount,DoJoinActivityReq doJoinActivityReq);

    Integer updateAlipayOrder(AlipayOrderDto dto);

    /**
     * 创建虚拟奖品券码订单
     * @param orderId 订单
     * @param option 奖项
     * @param doJoinActivityReq 参数
     * @return num
     */
    Integer createVirtualTicketOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq,CouponsCodeDto coupon);

    /**
     * 创建虚拟奖品api类型订单
     * @param orderId 订单id
     * @param option 奖项
     * @param doJoinActivityReq 参数
     * @param dto 奖品dto
     * @param amount 中奖金额（分）
     * @param amountStr 中奖金额(展示)
     * @return
     */
    Integer createVirtualApiOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq,PrizeDto dto,Integer amount,String amountStr);

    Integer createRedPacketOrder(String orderId, OptionDto option, DoJoinActivityReq doJoinActivityReq);

    AlipayOrderDto selectAlipayOrder(String orderId);

    /**
     * 更新订单(中福袋或者推啊券时使用).
     *
     * @param orderId 订单id
     * @param consumerId 用户id
     * @param option 奖项信息
     * @param couponData the coupon data
     * @throws ActivityException the activity exception
     */
    void updateOrder(String orderId, Long consumerId, OptionDto option, String couponData) throws ActivityException;


    /**
     * 创建插件工具订单.
     *
     * @return the long
     * @throws ActivityException the activity exception
     */
    RspOrder createPluginToolsOrder(DoJoinActivityReq doJoinPluginToolsReq) throws ActivityException;
    
    
    /**
     * 更新插件工具订单状态(中谢谢参与时使用).
     *
     * @param orderId 订单id
     * @param consumerId 用户id
     * @param option the option
     * @throws ActivityException the activity exception
     */
    void updatePluginToolsOrderThanks(String orderId, Long consumerId, OptionDto option)
                                                                                                      throws ActivityException;

    /**
     * 更新插件工具订单(中福袋或者推啊券时使用).
     *
     * @param orderId 订单id
     * @param consumerId 用户id
     * @param option 奖项信息
     * @param couponData the coupon data
     * @throws ActivityException the activity exception
     */
    void updatePluginToolsOrder(String orderId, Long consumerId, OptionDto option, String couponData) throws ActivityException;



    /**
     * 查询订单.
     *
     * @param orderId the order id
     * @param consumerId the consumer id
     * @return the activity order dto
     * @throws ActivityException the activity exception
     */
    ActivityOrderDto selectByIdAndConsumerId(String orderId, Long consumerId) throws ActivityException;

    /**
     * 判断是否展示浮标.
     *
     * @param activityDto the activity dto
     * @param slotDto     广告位配置信息
     * @param consumerId  the consumer id
     * @return true, if checks if is show buoy
     * @throws ActivityException the activity exception
     */
    boolean isShowBuoy(TuiaActivityDto activityDto, SlotDto slotDto, Long consumerId, int joinTimes, long styleType) throws ActivityException;

    AlipayRsp transferToAccount(AlipayReq req);

    List<AlipayOrderDto> selectAlipayRecord(String deviceId);

    Boolean submitPhysicalInfo(PhysicalReq req);
    /**
     * 支付宝订单查询接口
     *
     * @param reqAliOrderQuery
     * @return
     */
    List<AlipayOrderDto> selectAlipayRecords(ReqAliOrderQuery reqAliOrderQuery);

    /**
     * 提交虚拟奖品-用户信息
     *
     * @param virtualWinnerReq
     * @return
     */
    Boolean submitVirtualPrizeInfo(VirtualWinnerReq virtualWinnerReq) throws ActivityException;

    RechargeQBRsp rechargeQB(RechargeQBReq req);

    /**
     * 根据订单id查用户id查询.
     *
     * @param orderId the order id
     * @return the activity order dto
     * @throws ActivityException the activity exception
     */
    Long selectConsumerIdByOrderId(String orderId) throws ActivityException;

    /**
     * 添加奖品订单
     * @param dto
     * @return
     */
    Integer insertPrizeOrder(AlipayOrderDto dto);

    /**
     * 创建奖品订单
     * @param orderId 订单id
     * @param option 奖项
     * @param doJoinActivityReq 参与
     * @return
     */
    AlipayOrderDto createOrder(String orderId, OptionDto option,DoJoinActivityReq doJoinActivityReq);
}
