
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年3月20日下午6:44:23<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;


/**
 * 今日头条新闻广告点击上报参数
 * ClassName: TclickReq <br/>
 * date: 2017年8月20日 下午6:44:23 <br/>
 *
 * @author cdm
 * @version 
 * @since JDK 1.6
 */
@ApiModel
public class TAdclickReq {


    private String os;// 操作系 统 必填。“Android 或者 IOS”

    private String events;//事件列表 ， “[event1, event2, event3, enent4, ...]” 单个 event 的定义 下表 : 必填

    private String  language;//语言

    private String category;//填写“open”,必填

    private String tag; // 事件分类  填写'embeded_ad': 必填


    private String is_ad_event; // 是否是 ad 填写'1':必填
    private String label; // 频道标识  可选值有 show、click 。 告展示时值 为:show; 点击时为:click: 必填
    private Long value; //  告 id,即 ad_id : 必填
    private String log_extra; //  告中的 log_extra 字段原样填写即 可 : 必填

    private Long client_at; //  秒级时间戳: 必填
    private Long show_time; //  show 到点击的时 间间隔,单位为 毫秒
    private String client_ip; //   用户 ip

    private Long group_id ; //  章 id,即 group_id

    private String type;// 告上报时为 ad;新闻上报时为 news

    private String  t_category;//新闻类别

    public String getT_category() {
        return t_category;
    }

    public void setT_category(String t_category) {
        this.t_category = t_category;
    }

    public Long getGroup_id() {
        return group_id;
    }

    public void setGroup_id(Long group_id) {
        this.group_id = group_id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private Long  consumerId;//用户ID

    private Long appId;//appId

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }



    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }


    public String getEvents() {
        return  events;
    }

    public void setEvents(String events) {
        this.events = events;
    }


    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getIs_ad_event() {
        return is_ad_event;
    }

    public void setIs_ad_event(String is_ad_event) {
        this.is_ad_event = is_ad_event;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getValue() {
        return value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public String getLog_extra() {
        return StringUtils.isBlank(log_extra)? log_extra : StringEscapeUtils.unescapeHtml3(log_extra);
    }

    public void setLog_extra(String log_extra) {
        this.log_extra = log_extra;
    }

    public Long getClient_at() {
        return client_at;
    }

    public void setClient_at(Long client_at) {
        this.client_at = client_at;
    }

    public Long getShow_time() {
        return show_time;
    }

    public void setShow_time(Long show_time) {
        this.show_time = show_time;
    }

    public String getClient_ip() {
        return client_ip;
    }

    public void setClient_ip(String client_ip) {
        this.client_ip = client_ip;
    }
}

