/**
 * Project Name:tuia-youtui-web<br>
 * File Name:PrizeReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年2月5日下午4:18:34<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: PrizeReq <br/>
 * Function: 奖品信息请求. <br/>
 * date: 2017年2月5日 下午4:18:34 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class PrizeReq {

    /** The item id. */
    @NotNull(message = "奖品ID不能为空")
    @ApiModelProperty(value = "奖品ID", required = true)
    private Long optionId;

    /** The app item id. */
    private Long appItemId;

    /**
     * Gets the option id.
     *
     * @return the option id
     */
    public Long getOptionId() {
        return optionId;
    }

    /**
     * Sets the option id.
     *
     * @param optionId the option id
     */
    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

    /**
     * Gets the app item id.
     *
     * @return the app item id
     */
    public Long getAppItemId() {
        return appItemId;
    }

    /**
     * Sets the app item id.
     *
     * @param appItemId the app item id
     */
    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
