package com.duiba.tuia.youtui.web.model.req;

import org.apache.commons.lang.StringUtils;

import com.duiba.tuia.youtui.web.exception.ActivityRuntimeException;

public class LandUserInfo {

    private Long    userId;        // 用户表id

    private String  uid;           // 保险公司回传的用户id

    private Long    landId;        // 落地页id 

    private String  channel;       // 渠道

    private String  userName;      // 姓名

    private String  userPhone;     // 电话

    private String  identification; // 身份证

    private Integer sex;           // 性别

    private Long    birthday;      // 生日

    private String  address;       // 详细地址

    private String  region;        // 区

    private String  city;          // 市

    private String  province;      // 省份

    private String  info;          // 其他信息

    private String  landSubId;     // 若使用div表示多个页面，传div的标识，如123456-3（123456是landId，3代表第三个）

    private String  questionnaire; // 调查问券

    private Integer age;           // 年龄

    private String  profession;    // 职业

    private String  education;     // 学历

    private String  fee;           // 费用

    private String  email;         // 邮件

    private String  colour;        // 颜色

    private Integer number;        // 数量

    private String  orderMessage;  // 订单留言

    private String orderId;        // 订单号

    private String product;        //产品名称

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getLandId() {
        return landId;
    }

    public void setLandId(Long landId) {
        this.landId = landId;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel == null ? null : channel.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone == null ? null : userPhone.trim();
    }

    public String getIdentification() {
        return identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification == null ? null : identification.trim();
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region == null ? null : region.trim();
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city == null ? null : city.trim();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province == null ? null : province.trim();
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info == null ? null : info.trim();
    }

    public String getLandSubId() {
        return landSubId;
    }

    public void setLandSubId(String landSubId) {
        this.landSubId = landSubId;
    }

    public String getQuestionnaire() {
        return questionnaire;
    }

    public void setQuestionnaire(String questionnaire) {
        this.questionnaire = questionnaire;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getProfession() {
        return profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public String getEducation() {
        return education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getFee() {
        return fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getOrderMessage() {
        return orderMessage;
    }

    public void setOrderMessage(String orderMessage) {
        this.orderMessage = orderMessage;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getProduct() {
        return product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void checkParams() {
        if (StringUtils.isBlank(userName) || StringUtils.isBlank(userPhone) || StringUtils.isBlank(identification)) {
            throw new ActivityRuntimeException("参数[userName, userPhone, identification]不能为空");
        }

        if (landId == null) {
            throw new ActivityRuntimeException("参数landId 不能为空");
        }
    }

}
