/**
 * Project Name:tuia-youtui-web<br>
 * File Name:DoJoinActivityReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年1月17日下午12:48:42<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * ClassName: DoJoinActivityReq <br/>
 * Function: 参加活动请求参数. <br/>
 * date: 2017年1月17日 下午12:48:42 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class DoJoinActivityReq {

    /** 活动ID. */
    @NotNull(message = "活动ID不可为空")
    private Long    activityId;

    /** The slot id. */
    private Long    slotId;

    /** 活动类型. */
    private Integer activityType;

    /** 再来一次订单ID. */
    private Long    againOrderId;

    /** The app id. */
    private Long    appId;

    /** 用户 id. */
    private Long    consumerId;

    /** The ip. */
    private String  ip;

    /** The user agent. */
    private String  userAgent;

    /** The os. */
    private String  os;
    
    private String referer;
    
    /** 设备id*/
    private String deviceId;

    /** 媒体用户id*/
    private String userId;

    /**
     * 网络类型 2g ,3g,4g,wifi等
     */
    private String connection_type;
    
    /**福袋请求额外的参数*/
    private Map<String,String> paramMap;

    /** 区分流量来源， 广告出福袋的时候判断流量  */
    private String appFlowType;


    public String getAppFlowType() {
        return appFlowType;
    }

    public void setAppFlowType(String appFlowType) {
        this.appFlowType = appFlowType;
    }

    public String getConnection_type() {
        return connection_type;
    }

    public void setConnection_type(String connection_type) {
        this.connection_type = connection_type;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the os.
     *
     * @return the os
     */
    public String getOs() {
        return os;
    }

    /**
     * Sets the os.
     *
     * @param os the os
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * Gets the user agent.
     *
     * @return the user agent
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * Sets the user agent.
     *
     * @param userAgent the user agent
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * Gets the ip.
     *
     * @return the ip
     */
    public String getIp() {
        return ip;
    }

    /**
     * Sets the ip.
     *
     * @param ip the ip
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * Gets the consumer id.
     *
     * @return the consumer id
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * Sets the consumer id.
     *
     * @param consumerId the consumer id
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the activity id.
     *
     * @return the activity id
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * Sets the activity id.
     *
     * @param activityId the activity id
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * Gets the again order id.
     *
     * @return the again order id
     */
    public Long getAgainOrderId() {
        return againOrderId;
    }

    /**
     * Sets the again order id.
     *
     * @param againOrderId the again order id
     */
    public void setAgainOrderId(Long againOrderId) {
        this.againOrderId = againOrderId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public String getReferer() {
        return referer;
    }

    
    public void setReferer(String referer) {
        this.referer = referer;
    }

    
    public String getDeviceId() {
        return deviceId;
    }

    
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Map<String, String> getParamMap() {
        return paramMap;
    }

    
    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }
    
    

}
