package com.duiba.tuia.youtui.web.model.req;

import com.duiba.tuia.youtui.web.model.AdvertVO;
import io.swagger.annotations.ApiModel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 直投页接口请求
 */
@ApiModel
public class DirectPageReq implements Serializable {

    /**
     * 页面id
     */
    private Long                pageId;

    /**
     * 广告list
     */
    private List<AdvertVO>      adverts;

    /**
     * dsm
     */
    private String              dsm;

    /**
     * 广告位id
     */
    private Long                slotId;

    /**
     * 用户id
     */
    private Long                consumerId;

    /**
     * 设备id
     */
    private String              deviceId;

    /**
     * appId
     */
    private Long                appId;

    /**
     * host
     */
    private String              host;

    /**
     * 浮标id
     */
    private Long                buoyId;

    /**
     * 引导页类型
     */
    private Integer             pageType;

    /**
     * ip
     */
    private String              ip;

    /**
     * ua
     */
    private String              userAgent;

    /**
     * 操作系统
     */
    private String              os;

    /**
     * referer
     */
    private String              referer;

    /**
     * app key
     */
    private String              appKey;

    private String              login;

    private Map<String, String> paramMap;


    /** 区分流量来源， 广告出福袋的时候判断流量  */
    private String appFlowType;


    public String getAppFlowType() {
        return appFlowType;
    }

    public void setAppFlowType(String appFlowType) {
        this.appFlowType = appFlowType;
    }

    public DirectPageReq() {
        adverts = new ArrayList<>();
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public List<AdvertVO> getAdverts() {
        return adverts;
    }

    public void setAdverts(List<AdvertVO> adverts) {
        this.adverts = adverts;
    }

    public String getDsm() {
        return dsm;
    }

    public void setDsm(String dsm) {
        this.dsm = dsm;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Long getBuoyId() {
        return buoyId;
    }

    public void setBuoyId(Long buoyId) {
        this.buoyId = buoyId;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public Map<String, String> getParamMap() {
        return paramMap;
    }

    public void setParamMap(Map<String, String> paramMap) {
        this.paramMap = paramMap;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }
}
