
/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GetActivitysReq.java<br>
 * Package Name:com.duiba.tuia.youtui.web.model.req<br>
 * Date:2017年3月20日下午6:44:23<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;


/**
 * ClassName: GetActivitysReq <br/>
 * date: 2017年3月20日 下午6:44:23 <br/>
 *
 * @author youhaijun
 * @version 
 * @since JDK 1.6
 */
@ApiModel
public class AlipayReq {


    @NotNull(message = "订单号不可为空")
    @Length(min=13, max=64)
    private String orderId;//订单号

    @NotNull(message = "支付宝账户不可为空")
    @Pattern(regexp = "(^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\\\D])|(18[0,5-9]))\\\\d{8}$)|(^([a-z0-9A-Z]+[-|\\\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\\\.)+[a-zA-Z]{2,}$)", message = "您的支付宝账户必须是手机号或者邮箱,请验证.")
    private String account;//用户账户

    private String name ;//用户名

    @NotNull(message = "金额不可为空")
    @Length(min=1, max=5)
    private String amount;//金额

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }
}

