package com.duiba.tuia.youtui.web.model;

import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * 活动web支持的同盾游客登录参数
 */
public class CommonLoginReq implements Serializable {

    private String appKey;

    private String redirectUrl;

    private Long slotId;

    private String deviceId;

    private String tokenId;

    @ApiModelProperty(value = "性别，1:男 2:女", required = false)
    @Range(min=1, max=3, message = "性别有误，请重新输入")
    private Integer sex;
    /**
     * 昵称
     */
    private String nickName;

    /**
     * 头像
     */
    private String img;

    public boolean checkParam(){
        Preconditions.checkNotNull(this.appKey, "参数{}错误", "appKey");
        Preconditions.checkNotNull(this.slotId, "参数{}错误", "slotId");
        return true;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getTokenId() {
        return tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }
}
