package com.duiba.tuia.youtui.web.message;

import com.duiba.tuia.youtui.web.exception.ActivityRuntimeException;

/**
 * 活动web清除缓存的父类的监听
 * @author lichao 2018/4/20
 */
public abstract class ActivityWebCacheBashHandler extends AbstractMessageResultHandler {

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    public abstract String getListenTag();

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    public void consumer(String message){
        try {
            this.consumerNative(message);
        }catch (Exception e){
            throw new ActivityRuntimeException(e);
        }
    }


    public abstract void consumerNative(String message);


    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }

}
