/**
 * Project Name:tuia-youtui-web File Name:StatCouponDownLog.java Package Name:com.duiba.tuia.youtui.web.log
 * Date:2017年2月20日下午6:23:31 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.duiba.tuia.youtui.web.log;

import cn.com.duiba.tuia.activity.center.api.dto.OptionDto;
import cn.com.duiba.tuia.activity.center.api.dto.RspOrder;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.model.req.DoJoinActivityReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ClassName:StatCouponDownLog <br/>
 * Date: 2017年2月20日 下午6:23:31 <br/>.
 *
 * @author zp
 * @version
 * @since JDK 1.6
 * @see
 */
public class StatCouponDownLog {

    /** The log. */
    private static Logger log = LoggerFactory.getLogger(StatCouponDownLog.class);

    /**
     * The Constructor.
     */
    private StatCouponDownLog() {
    }

    /**
     * Log.
     *
     * @param option the option
     * @param doJoinActivityReq the do join activity req
     * @param rspOrder the rsp order
     * @param advert the advert
     */
    public static void log(OptionDto option, DoJoinActivityReq doJoinActivityReq, RspOrder rspOrder,
                           ObtainAdvertRsp advert) {
        try {
            JSONObject json = new JSONObject();
            json.put("prizeType", option.getPrizeType());
            json.put("prizeId", option.getId());
            json.put("consumerId", doJoinActivityReq.getConsumerId());
            json.put("advertId", option.getAdvertId());
            json.put("orderId", rspOrder.getOrderId());
            json.put("activityId", doJoinActivityReq.getActivityId());
            json.put("activityType", doJoinActivityReq.getActivityType());

            if (null == advert) {
                log.info("奖项->{},广告平台返回null", json);
            } else {
                log.info("奖项->{},广告平台返回advertId={},title={},image={}", json, advert.getAdvertId(), advert.getTitle(), advert.getThumbnailPngUrl());
            }
        } catch (Exception e) {
            log.error("StatCouponDownLog 失败", e);
        }
    }
}
