package com.duiba.tuia.youtui.web.log;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.tuia.activity.center.api.constant.FieldNameSpace;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.constant.InnerLogCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.Map;

/**
 * The Class InnerLogService.
 */
public class InnerLogService {

    /** The Constant log. */
    private static final Logger log = LoggerFactory.getLogger(InnerLogService.class);

    private InnerLogService() {
    }

    /**
     * Log.
     *
     * @param json the json
     */
    public static void log(String json) {
        if(!PerfTestContext.isCurrentInPerfTestMode()){
            log.info(json);
        }

    }

    /**
     * log:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param operatingActivityId the operating activity id
     * @param appId the app id
     * @param activityType the activity type
     * @param orderId the order id
     * @param code the code
     * @param msg the msg
     * @since JDK 1.6
     */
    public static void log(Long operatingActivityId, Long appId, String activityType, String orderId, String code,
                           String msg) {
        try {
            log(format(operatingActivityId, appId, activityType, orderId, code, msg));
        } catch (Exception e) {
            log.error("StatActivityThanksLog 失败", e);
        }
    }

    /**
     * Format.
     *
     * @param operatingActivityId the operating activity id
     * @param appId the app id
     * @param activityType the activity type
     * @param orderId the order id
     * @param code the code
     * @param msg the msg
     * @return the string
     */
    private static String format(Long operatingActivityId, Long appId, String activityType, String orderId,
                                 String code, String msg) {
        JSONObject json = new JSONObject();
        json.put(FieldNameSpace.ACTIVITY_ID, operatingActivityId);
        json.put(FieldNameSpace.APP_ID, appId);
        json.put(FieldNameSpace.ACTIVITY_TYPE, activityType);
        json.put(Constants.VALUENAME.ORDER_ID, orderId);
        json.put("code", code);
        json.put("msg", msg);
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, 1);
        jsonLog.put(Constants.VALUENAME.TYPE, 14);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        return jsonLog.toJSONString();
    }

    public static void landPageLog(Integer group, Integer type, JSONObject json) {
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, group);
        jsonLog.put(Constants.VALUENAME.TYPE, type);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    public static void antiCheatingLog(Map<String, Object> params, JSONObject json) {
        json.put(FieldNameSpace.ACTIVITY_ID, params.get("ext_activity_id"));
        json.put(FieldNameSpace.APP_ID, params.get("ext_media_id"));
        json.put(Constants.VALUENAME.CONSUMER_ID, params.get("account_login"));
        json.put(FieldNameSpace.SLOT_ID, params.get("slotId"));
        json.put(Constants.VALUENAME.ADVERT_ID, params.get("ext_Advertising_id"));
        json.put("rid", params.get("ext_requestid"));
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, 1);
        jsonLog.put(Constants.VALUENAME.TYPE, 33);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    /**
     * 头条广告点击日志
     * @param params 参数
     * @param json json
     */
    public static void tadClickLog(Map<String, Object> params, JSONObject json) {
        json.put(Constants.VALUENAME.SET_DATA,params);
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.TOUTIAO_AD_INNER_TYPE);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    /**
     * 头条不喜欢点击日志
     * @param params 参数
     * @param json json
     */
    public static void tDisLikeLog(Map<String, Object> params, JSONObject json) {
        json.put(Constants.VALUENAME.SET_DATA,params);
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.TOUTIAO_AD_DIS_LIKE_INNER_TYPE);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    /**
     * 头条新闻点击日志
     * @param params 参数
     * @param json json
     */
    public static void tNewsLog(Map<String, Object> params, JSONObject json) {
        params.put("label","click");
        json.put(Constants.VALUENAME.SET_DATA,params);
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.TOUTIAO_NEWS_INNER_TYPE);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    /**
     * 根据分配的inner内部日志打印相关日志
     * @param group   分配的group
     * @param type    分配的type
     * @param json    具体的json数据
     */
    public static void innerJsonObject(Integer group, Integer type,JSONObject json) {
        landPageLog(group, type, json);
    }

    /**
     * 客服信息模版-域名
     *
     * @param host
     */
    public static void contactPlateLog(String host, Long id) {
        JSONObject json = new JSONObject();
        json.put(Constants.VALUENAME.HOST,host);
        json.put(Constants.VALUENAME.ID,id);
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.CONTACT_PLATE_HOST);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    /**
     * 与第三方交互的日志
     * @param url
     * @param requestBody
     * @param responseBody
     */
    public static void httpLog(String url, String requestBody, String responseBody) {
        JSONObject json = new JSONObject();

        json.put("url", url);
        json.put("requestBody", requestBody);
        json.put("responseBody", responseBody);

        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.HTTP_TYPE);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());
    }

    public static void prizeLimitLog(Long slotId, Long activityId,Integer activityType, Long optionId, String deviceId, String ip,String orderId) {
        JSONObject json = new JSONObject();
        json.put(Constants.SLOTID, slotId);
        json.put(FieldNameSpace.ACTIVITY_ID, activityId);
        json.put(FieldNameSpace.ACTIVITY_TYPE, activityType);
        json.put("optionId", optionId);
        json.put(Constants.DEVICE_ID, deviceId);
        json.put("ip", ip);
        json.put(Constants.VALUENAME.ORDER_ID, orderId);

        JSONObject jsonLog = new JSONObject();
        jsonLog.put(Constants.VALUENAME.GROUP, InnerLogCode.INNER_GROUP);
        jsonLog.put(Constants.VALUENAME.TYPE, InnerLogCode.HTTP_TYPE);
        jsonLog.put(Constants.VALUENAME.TIME, DateUtils.getSecondStr(new Date()));
        jsonLog.put(Constants.VALUENAME.JSON, json);
        log(jsonLog.toJSONString());

    }
}
