package com.duiba.tuia.youtui.web.handle.prize;

import cn.com.duiba.tuia.activity.center.api.constant.ActivityOptionType;
import com.duiba.tuia.youtui.web.handle.FilterParams;
import com.duiba.tuia.youtui.web.log.InnerLogService;
import com.duiba.tuia.youtui.web.service.ActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 校验同一用户当日抽奖限制，如果该用户已经中过该奖项，不抽取该奖品
 * 根据奖项id，ip，consumerId 校验
 * Created by 清郎 on 2018/01/31.
 */
@Component
public class UserDayLimitFilter extends PrizeFilter {

    @Autowired
    private ActivityService activityService;


    @Override
    protected void configPrizes() {
        super.configPrizes(ActivityOptionType.TYPE_ALIPAY, ActivityOptionType.TYPE_PHYSICAL, ActivityOptionType.TYPE_BILL, ActivityOptionType.TYPE_QB);
    }

    @Override
    public boolean doFilter(FilterParams filterParams) {
        Long optionId = filterParams.getOptionId();
        String deviceId = filterParams.getDeviceId();
        String ip = filterParams.getIp();

        boolean rs = activityService.isHaveWonPrizeDay(optionId, deviceId, ip);
        if (rs) {
            InnerLogService.prizeLimitLog(filterParams.getSlotId(), filterParams.getActivityId(), filterParams.getActivityType(), optionId, deviceId, ip, filterParams.getOrderId());
        }
        return rs;
    }

    @Override
    public int getOffset() {
        return 0;
    }
}
