package com.duiba.tuia.youtui.web.handle;

import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 *
 * Created by 清郎 on 2018/01/31.
 */
public class FilterHandle {
    protected List<FilterChain> filters = new ArrayList<>();

    protected void register(FilterChain... filterChain) {
        filters.addAll(Lists.newArrayList(filterChain));
        filters.sort(Comparator.comparingInt(FilterChain::getOffset));
    }

    public boolean doFilter(FilterParams filterParams) {
        for (FilterChain filter : filters) {
            if (filter.doFilter(filterParams)) {
                return true;
            }
        }
        return false;
    }
}
