package com.duiba.tuia.youtui.web.filter;

import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.service.DirectPageSourceService;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.stream.Stream;

/**
 * 主会场来源直投页数据获取拦截器
 * 当经过直投页时进行过滤,去除掉key
 *
 * @author lichao 2018/3/25
 */
@Component
public class DirectPageSourceInterceptor extends HandlerInterceptorAdapter {

	/**
	 * 不过滤的url，如曝光日志，点击日志
	 */
	private String[] notFilterUrl = {"/engine/spmshow","/activity/showLog","/exposure/"};

	/**
	 * redisClient
	 */
	@Resource
	private DirectPageSourceService directPageSourceService;

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		if (StringUtils.isNotBlank(request.getParameter(Constants.TENTER))) {
			String url = request.getRequestURI();
			boolean b = Stream.of(notFilterUrl).noneMatch(input -> url.contains(input));
			if (b) {
				//来源于资源位,则清楚掉
				Long consumerId = RequestLocal.get().getCid();
				directPageSourceService.delete(consumerId);
			}
		}

		return true;
	}
}
