package com.duiba.tuia.youtui.web.embed;

import com.duiba.tuia.youtui.web.constant.DeliveryType;

import java.util.Map;

/**
 * 直投页埋点
 * Created by wubo on 2017/9/1.
 */
public class DirectEmbed extends Embed {

    private Integer deliveryType = DeliveryType.DIRECT_PAGE.getType();

    //突然 发现用transient不会阻止 JSONObject.toJSONString 生成json
    private transient Integer regionNum;
    private transient Integer blockNum;
    private transient Long pageId;

    private Long directpage;

    public DirectEmbed(String dcm, String dsm, String dpm, Long consumerId, Long appId, String host,Long directpage) {
        super(dcm, dsm, dpm, consumerId, appId, host);
        this.directpage=directpage;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public DirectEmbed setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
        return this;
    }

    public Map<String, String> buildAdvertEmbed() {
        super.buildClickEmbed();
        super.buildExposureEmbed();
        return super.embed();
    }

    public Integer getRegionNum() {
        return regionNum;
    }

    public void setRegionNum(Integer regionNum) {
        this.regionNum = regionNum;
    }

    public Integer getBlockNum() {
        return blockNum;
    }

    public void setBlockNum(Integer blockNum) {
        this.blockNum = blockNum;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public Long getDirectpage() {
        return directpage;
    }

    public void setDirectpage(Long directpage) {
        this.directpage = directpage;
    }
}
