package com.duiba.tuia.youtui.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.model.rsp.GameResultRsp;
import com.duiba.tuia.youtui.web.model.rsp.GameRsp;
import com.duiba.tuia.youtui.web.model.rsp.RankInfoRsp;
import com.duiba.tuia.youtui.web.model.rsp.StartFishGameRsp;
import com.duiba.tuia.youtui.web.service.GameService;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Administrator on 2018/1/24.
 * 捕鱼游戏API
 */
@Controller
@RequestMapping("/game")
@Api("游戏API")
public class GameController extends BaseController {

    @Autowired
    private GameService gameService;

    /**
     * 游戏index加载首页
     *
     * @param
     */
    @RequestMapping(value = "/index")
    @ResponseBody
    public ModelAndView index(IndexReq req, HttpServletRequest request) {
        try {
            UserAccount consumer = RequestLocal.get().getUserAccount();
            try {
                Cat.logMetricForCount("活动中心-游戏访问");
            } catch (Exception e) {
                logger.error(Constants.CAT_ERROR, e);
            }
            req.setHost(request.getHeader("host"));
            return gameService.index(req, consumer, request);
        } catch (Exception e) {
            logger.warn("游戏加载失败:" + req.getId(), e);
            return new ModelAndView(Constants.MODEL_ERROR);
        }
    }

    /**
     * 校验用户是否可以开始依据游戏，可以就生成并缓存游戏局id
     *
     * @return 此次游戏单局id和账户余额游戏币
     */
    @RequestMapping(value = "/startGame")
    @ResponseBody
    @ApiOperation(value = "开始游戏接口", httpMethod = "GET", notes = "开始一局游戏")
    public StartFishGameRsp startGame(String userName) {
        UserAccount consumer = RequestLocal.get().getUserAccount();
        return gameService.startGame(consumer.getUserId(),userName);
    }

    /**
     * 根据赔率计算命中
     *
     * @param id 游戏ID
     * @param singleId 此局ID
     * @param attackValue 炮筒攻击力
     * @param level 怪物级别
     * @param
     * @return 是否中奖
     */
    @RequestMapping(value = "/singleDoJoin")
    @ResponseBody
    @ApiOperation(value = "计算是否打中怪物接口", httpMethod = "GET", notes = "返回是否成功和余额等信息")
    public GameRsp singleDoJoin(Long id, String singleId, Integer attackValue, Integer level) {
        UserAccount consumer = RequestLocal.get().getUserAccount();
        return gameService.singleDoJoin(id,singleId,attackValue,level,consumer);
    }

    /**
     * 获取单据游戏结果
     *
     * @param singleId 游戏单局ID
     * @return 游戏结果
     */
    @RequestMapping(value = "/getResult")
    @ResponseBody
    @ApiOperation(value = "获取游戏结果", httpMethod = "GET", notes = "击中怪物等信息")
    public GameResultRsp getResult(String singleId) {
        UserAccount consumer = RequestLocal.get().getUserAccount();
        return gameService.getResult(singleId,consumer.getUserId());
    }

    /**
     * 获取单据游戏排名+一张广告券
     *
     * @param singleId 游戏单局ID
     * @param id 游戏id
     * @return 游戏结果
     */
    @RequestMapping(value = "/getRank")
    @ResponseBody
    @ApiOperation(value = "获取排行榜及广告信息", httpMethod = "GET", notes = "用户排行榜")
    public RankInfoRsp getRank(String singleId, Long id,String dcm,String dpm, String dsm, HttpServletRequest request) {
        UserAccount consumer = RequestLocal.get().getUserAccount();
        return gameService.getRankInfo(singleId,consumer, id, dsm, request);
    }

    /**
     * 获取中奖公示信息
     *
     * @return
     */
    @RequestMapping(value = "/getWinPublic")
    @ResponseBody
    @ApiOperation(value = "中奖公示", httpMethod = "GET", notes = "中奖公示")
    public List<String> getWinPublic() {
        return gameService.getWinPublic();
    }

    /**
     * 获取捕鱼达人游戏埋点
     *
     * @return
     */
    @RequestMapping(value = "/getFishEmbed")
    @ResponseBody
    @ApiOperation(value = "埋点接口", httpMethod = "GET", notes = "埋点接口")
    public JSONObject getFishEmbed(Long gameId, String dsm, HttpServletRequest request) {
        Long userId = RequestLocal.get().getCid();
        String host = request.getHeader("host");
        Long appId = RequestLocal.get().getAppId();
        return gameService.getFishEmbed(gameId, dsm, appId, userId, host);
    }

}
