/**
 * Project Name:tuia-youtui-web
 * File Name:StatisticsCtrl.java
 * Package Name:com.duiba.tuia.youtui.web.controller
 * Date:2017年4月10日下午3:44:26
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.duiba.tuia.youtui.web.controller;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * ClassName:ExposureController <br/>
 * Function:  活动web曝光统计Controller，无任何业务逻辑. <br/>
 * Date:     2017年4月10日 下午3:44:26 <br/>
 * @author   cmd
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@Controller
@RequestMapping("exposure")
public class ExposureController {
    
    /***
         * @Description: buoy 浮标曝光统计
         * 统计参数：
         * dpm=17802.21.37.94&consumer_id=10042001&app_id=17802&slot_id=111
         * @Param: [] 
         * @Return: void 
         * @throws:  
         * @author: youhaijun
         * @Date:   2017/8/21
         */
    @ResponseBody
    @RequestMapping(value = "buoy",  method = {RequestMethod.GET,RequestMethod.POST})
    public void buoy(HttpServletRequest request) {
        return;
    }

    /**
     *  活动中奖弹层统计
     *  统计参数：
     *  dpm=24167.4.1.0&orderId=taw-24415564630389&consumerId=1700003205&deliveryType=1&device_type=tuia&materialId=9723&advertId=9216&dcm=&dcm=104.10808.123(弹层ID).11581&activityId=702&appId=24167
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/layer", method = {RequestMethod.GET,RequestMethod.POST})
    public void layer(HttpServletRequest request) {
        return;
    }

    /**
     *  普通插件曝光统计
     *  统计参数：
     *  dpm=34313.38.1.0&consumer_id=1700003220&app_id=34313&dcm=702.28.2.9
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/plugin", method = {RequestMethod.GET,RequestMethod.POST})
    public void plugin(HttpServletRequest request) {
        return;
    }

    /**
     *  普通谢谢参与推荐弹层曝光统计
     *  统计参数：
     *  dpm=appId.53.0.0&consumer_id=1700003220&app_id=34313&dcm=1010.0.0.0
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/thanks", method = {RequestMethod.GET,RequestMethod.POST})
    public void thanks(HttpServletRequest request) {
        return;
    }


}

