/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GuidePageController.java<br>
 * Package Name:com.duiba.tuia.youtui.web.controller<br>
 * Date:2017年3月2日下午5:32:21<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.tuia.activity.center.api.dto.AlipayOrderDto;
import cn.com.duiba.tuia.activity.center.api.dto.AlipayRsp;
import cn.com.duiba.tuia.activity.center.api.dto.RechargeQBRsp;
import com.duiba.tuia.youtui.web.bo.PrizeBO;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.req.*;
import com.duiba.tuia.youtui.web.service.ActivityOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

/**
 * ClassName: AlipayController <br/>
 * 活动中心controller date: 2017年3月2日 下午5:32:21 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/alipay")
@Api("奖品实发API")
public class AlipayController extends BaseController {

    @Autowired
    private ActivityOrderService activityOrderService;
    @Autowired
    private PrizeBO prizeBO;

    @ResponseBody
    @RequestMapping(value = "/transferToAccount", method = RequestMethod.POST)
    @ApiOperation(value = "transferToAccount", httpMethod = "POST", notes = "支付宝转账接口")
    public Result<AlipayRsp> transferToAccount(@ModelAttribute AlipayReq req, HttpServletRequest request) {
        try {
            return successResult(activityOrderService.transferToAccount(req));
        } catch (Exception e) {
            logger.warn("调用支付宝转账接口失败,订单orderId :" + req.getOrderId(), e);
            return failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/submitPhysicalInfo", method = RequestMethod.POST)
    @ApiOperation(value = "submitPhysicalInfo", httpMethod = "POST", notes = "实物提交信息接口")
    public Result<Boolean> submitPhysicalInfo(@ModelAttribute PhysicalReq req, HttpServletRequest request) {
        try {
            return successResult(prizeBO.submitPhysicalInfo(req));
        } catch (Exception e) {
            logger.warn("调用实物信息提交接口失败,订单orderId :" + req.getOrderId(), e);
            return failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/rechargeQB", method = RequestMethod.POST)
    @ApiOperation(value = "rechargeQB", httpMethod = "POST", notes = "充值QB接口")
    public Result<RechargeQBRsp> rechargeQB(@ModelAttribute RechargeQBReq req) {
        try {
            return successResult(activityOrderService.rechargeQB(req));
        } catch (Exception e) {
            logger.warn("调用QB充值接口失败,订单orderId :" + req.getOrderId(), e);
            return failResult(e);
        }
    }

    /**
     * 虚拟奖品-提交用户信息
     *
     * @param virtualWinnerReq
     * @return
     */
    @ResponseBody
    @RequestMapping("/submitVirtualPrizeInfo")
    @ApiOperation(value = "submitVirtualPrizeInfo", httpMethod = "POST", notes = "虚拟奖品-提交用户信息")
    public Result<Boolean> submitVirtualPrizeInfo(@ModelAttribute VirtualWinnerReq virtualWinnerReq) {
        try {
            return successResult(activityOrderService.submitVirtualPrizeInfo(virtualWinnerReq));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    /**
     * 虚拟奖品-领取结果
     *
     * @param orderId
     * @return
     */
    @ResponseBody
    @RequestMapping("/virtualPrizeResult")
    @ApiOperation(value = "virtualPrizeResult", httpMethod = "GET", notes = "虚拟奖品-领取结果")
    public Result<Integer> virtualPrizeResult(@Valid String orderId) {
        try {
            AlipayOrderDto order = activityOrderService.selectAlipayOrder(orderId);
            return successResult(order == null ? 0 : order.getStatus());
        } catch (Exception e) {
            return failResult(e);
        }
    }

}
