/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GuidePageController.java<br>
 * Package Name:com.duiba.tuia.youtui.web.controller<br>
 * Date:2017年3月2日下午5:32:21<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.controller;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.duiba.tuia.youtui.web.bo.MainMeetBO;
import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.constant.ErrorCode;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import com.duiba.tuia.youtui.web.model.Result;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.model.req.GetActivitysReq;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.model.rsp.GetActivitysRsp;
import com.duiba.tuia.youtui.web.model.rsp.UrlRsp;
import com.duiba.tuia.youtui.web.tool.RequestLocal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

/**
 * ClassName: GuidePageController <br/>
 * 活动中心controller date: 2017年3月2日 下午5:32:21 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/actCenter")
@Api("活动中心API")
public class ActCenterController extends BaseController {

    @Autowired
    private MainMeetBO mainMeetBO;

    @RequestMapping(value = "/index", method = RequestMethod.GET)
    ModelAndView index(@ModelAttribute IndexReq req, HttpServletRequest request) throws ActivityException {
        // 1.获取用户信息
        UserAccount consumer = RequestLocal.get().getUserAccount();
        if (null == consumer || null == req.getId()) {
            return new ModelAndView(Constants.MODEL_ERROR);
        }
        try {
            Cat.logMetricForCount("活动中心-活动中心访问");
        } catch (Exception e) {
            logger.error(Constants.CAT_ERROR, e);
        }
        try {
            req.setHost(request.getHeader("host"));
            AccessLogFilter.putExPair("use_host",request.getHeader("host"));
            AccessLogFilter.putExPair("agreement",request.getHeader("X-Forwarded-Proto")==null?"http":request.getHeader("X-Forwarded-Proto"));
            return mainMeetBO.index(request,req, consumer);
        } catch (Exception e) {
            logger.warn("初始化活动中心失败，请检查活动中心ID :" + req.getId(), e);
            return new ModelAndView(Constants.MODEL_ERROR);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/getActivitys", method = RequestMethod.GET)
    @ApiOperation(value = "getActivitys", httpMethod = "GET", notes = "获取活动中心活动接口")
    public Result<GetActivitysRsp> getActivitys(@ModelAttribute GetActivitysReq req, HttpServletRequest request) {
        try {
            IndexReq indexReq = BeanUtils.copy(req,  IndexReq.class);
            if (StringUtils.isBlank(req.getSlotId())) {
                throw new ActivityException(ErrorCode.E0000001);
            }
            indexReq.setSlotId(Long.parseLong(req.getSlotId()));
            indexReq.setHost(request.getHeader("host"));
            return successResult(mainMeetBO.getActivity4ActCenter(indexReq, req.getNum(), request));
        } catch (Exception e) {
            logger.warn("初始化活动中心失败，请检查活动中心ID :" + req.getId(), e);
            return failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/getAdCounts", method = {RequestMethod.GET,RequestMethod.POST})
    @ApiOperation(value = "getAdCounts", httpMethod = "GET", notes = "获取活动中心广告展示次数")
    public Result<JSONObject> result(@Valid String location, HttpServletRequest request, HttpServletResponse response) {
        try {
            return successResult(mainMeetBO.getAdvertCounts(request));
        } catch (Exception e) {
            return failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value = "/getActCenter")
    @ApiOperation(value="getActCenter",httpMethod = "GET", notes = "获取活动中心url接口")
    public Result<UrlRsp> getActCenter(IndexReq req, HttpServletRequest request, HttpServletResponse response) {
        try {
            req.setHost(request.getHeader("host"));
            return successResult(new UrlRsp(mainMeetBO.getActCenterUrl(request, req)));
        } catch (Exception e) {
            return failResult(e);
        }
    }
}
