package com.duiba.tuia.youtui.web.constant;

import com.duiba.tuia.youtui.web.tool.RequestLocal;
import com.duiba.tuia.youtui.web.tool.RequestTool;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 临时功能
 * <p>
 * 一些临时的测试需求，例如某某id要干嘛干嘛，类似的id 定义在这个类里
 */
public class TempFunction {

    private TempFunction() {
    }

    private static final Set<Long> DISPLAY_BUOY = Sets.newHashSet(5730L, 5731L, 5732L, 5733L, 5734L, 5735L);

    // 固定广告位定制浮标 start
    /* 浮标在第几次活动后展示的临时需求，只对以下广告位测试 */
    private static final Set<Long> SPLIT_SLOT_ID_LIST = Sets.newHashSet(111L, 201L, 711L, 1205L, 1406L, 1548L, 1624L, 1830L, 1894L, 1948L, 1966L, 2215L, 2689L, 2737L, 2876L, 2985L, 3118L, 3125L, 3950L, 4138L, 4187L, 4379L, 4492L, 4546L, 4616L, 4941L, 5548L, 6201L, 6220L, 6577L, 6736L, 6785L, 7468L, 7497L, 7524L, 7710L, 8047L, 9069L);
    private static final List<Long> MAIN_MEET_ID_LIST = Lists.newArrayList(977L, 978L, 979L);
    // 固定广告位定制浮标 end


    // 定制需求 -- start
    private static final Set<Long> CUSTOM_BUOY_ACTIVITY_IDS = Sets.newHashSet(4894L, 4895L, 4896L, 4897L, 4898L, 4899L);//符合的活动id
    public static final Long CUSTOM_BUOY_ID = 153L;//固定出的浮标id
    public static final Long CUSTOM_PAGE_ID = 795L;//固定出的主会场id
    // 定制需求 -- end


    // start 返回拦截 配置传奇直投页 临时需求
    public static final Long CHUAN_QI_DIRECT_PAGE_ID = Long.valueOf(967L);
    public static final Long CHUAN_QI_DIRECT_ADVERT_ID = Long.valueOf(27967L);
    // end 返回拦截 配置传奇直投页 临时需求


    // 唯品会 定制需求  -- start
    private static final Set<Long> WPH_APP_ID_LIST = Sets.newHashSet(25414L, 43080L, 26744L, 33833L, 44984L, 23251L, 43080L, 23898L, 26744L, 45207L, 42766L, 25414L, 33833L, 37214L, 28534L, 44984L, 46242L, 29685L, 43861L, 36173L, 44033L, 25399L, 43477L, 28124L, 40265L);//所应用到的媒体
    public static final Long WPH_BUOY_ID = 201L;
    //唯品会浮标链接
    public static final String WPH_BUOY_URL = "https://dmp-data.vip.com/deeplink/showWebview?url=https%3A%2F%2Fviva.vip.com%2FHVrm52FYmbtuwWsj_ouuLw.html%3Fwapid%3Dvivap_8350&tra_from=tra%3A3ys38dbl%3A%3A%3A%3A";
    public static final String WPH_RECOMMEND_URL = "https://dmp-data.vip.com/deeplink/showChannel?channelID=%23top-beauty&channelMenu=0&tra_from=tra%3Ar1d1b77a%3A%3A%3A%3A";//推荐位链接
    public static final String WPH_MATERIAL_URL = "//yun.tuisnake.com/h5-mami/insurance/season/640x280.jpg";
    // 唯品会 定制需求 -- end

    public static boolean displayBuoy(Long activityId) {
        return activityId == null || !DISPLAY_BUOY.contains(activityId);
    }

    /**
     * 需求链接 http://cf.dui88.com/pages/viewpage.action?pageId=7672599
     *
     * @param activityId
     * @param pageId
     * @return
     */
    public static boolean customBuoy(Long activityId, Long pageId) {
        return CUSTOM_BUOY_ACTIVITY_IDS.contains(activityId) && Long.valueOf(433L).equals(pageId);
    }

    /**
     * 判断当前广告位是否是临时需求的广告位
     * <p>
     * 临时需求：http://cf.dui88.com/pages/viewpage.action?pageId=8527980
     *
     * @param slotId
     * @return
     */
    public static boolean isTmpDemandSlot(Long slotId) {
        return slotId != null && SPLIT_SLOT_ID_LIST.contains(slotId);
    }

    /**
     * 临时广告位出的固定主会场
     * <p>
     * 临时需求：http://cf.dui88.com/pages/viewpage.action?pageId=8527980
     *
     * @return
     */
    public static Long getTmpDemandMainMeetId() {
        return MAIN_MEET_ID_LIST.get(ThreadLocalRandom.current().nextInt(3));
    }

    /**
     * 判断当前广告位是否是唯品会临时需求的广告位
     * <p>
     * 临时需求：http://cf.dui88.com/pages/viewpage.action?pageId=8546621
     *
     * @param appId
     * @param wphTmpDemand
     * @param isRecommend <浮标true>全量媒体</浮标true> <推荐位false>定制媒体</推荐位false>
     * @return
     */
    public static boolean isWPHTmpDemandApp(Long appId, String wphTmpDemand, boolean isRecommend) {
        return ((appId != null && WPH_APP_ID_LIST.contains(appId)) || isRecommend)
                && RequestTool.getUA(RequestTool.getUserAgent(RequestLocal.get().getRequest())).equals("Android")
                && !StringUtils.isEmpty(wphTmpDemand) && wphTmpDemand.equals("true");
    }

}
