/**
 * 文件名： MemcachedKeyTool.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月8日 上午11:17:51
 */
package com.duiba.tuia.youtui.web.tool;

/**
 * 缓存标识.
 *
 * @author: leiliang
 * @version:
 */
public class CachedKeyUtils {

    /** The prefix. */
    private static String prefix;

    /**
     * The Constructor.
     */
    private CachedKeyUtils() {
    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CachedKeyUtils.prefix = prefix;
    }

    /**
     * 获取redis缓存key.
     *
     * @param key CacheKey中定义的缓存key标识
     * @param param 需要加到key中的参数列表
     * @return redis key
     */
    public static String getRedisKey(String key, Object... params) {
        StringBuilder redisKey = new StringBuilder(getPrefix() + key);

        for (Object param : params) {
            redisKey.append("-" + param);
        }

        return redisKey.toString();
    }


}
