package com.duiba.tuia.youtui.web.tool;

import cn.com.duiba.tuia.activity.center.api.dto.TuiaActivityDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/6/8.
 */
public class ActivityUtil {

    private ActivityUtil() {
    }

    /**
     * @Description: getActivityMap 根据传入的活动list获取对应的活动map,id为key
     *
     * @Param: [lists]
     * @Return: java.util.Map<java.lang.Long,cn.com.duiba.tuia.activity.center.api.dto.TuiaActivityDto>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/6/8
     */
    public static Map<Long, TuiaActivityDto> getActivityMap(List<TuiaActivityDto> lists) {
        Map<Long, TuiaActivityDto> actMap = new HashMap<>();
        for (TuiaActivityDto dto : lists) {
            actMap.put(dto.getId(), dto);
        }
        return actMap;
    }

    /**
     * 按照以后的活动id列表顺序对活动list做排序.
     *
     * @param actList the act list
     * @param actIdList the act id list
     * @return the list< tuia activity dto>
     */
    public static List<TuiaActivityDto> sortActivityList(List<TuiaActivityDto> actList, List<Long> actIdList) {
        List<TuiaActivityDto> activityList = new ArrayList<>();
        if (actList.isEmpty() || actIdList.isEmpty()) {
            return activityList;
        }
        Map<Long, TuiaActivityDto> map = getActivityMap(actList);

        for (Long id : actIdList) {
            if (null != map.get(id)) {
                activityList.add(map.get(id));
            }
        }
        return activityList;
    }
}
