/**
 * Project Name:tuia-youtui-web<br>
 * File Name:FraudApiRequest.java<br>
 * Package Name:com.duiba.tuia.youtui.web.tongdun<br>
 * Date:2017年5月15日下午3:33:34<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.tongdun;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: FraudApiRequest <br/>
 * date: 2017年5月15日 下午3:33:34 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class FraudApiRequest implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long   serialVersionUID = -6245680051605089100L;
    // 访问同盾API
//    public static final String  API_URL          = "https://api.tongdun.cn/riskService/v1.1";
    public static final String  API_URL          = "https://api.tongdun.cn/antifraudService/v1.1";//同盾反欺诈集群

    // 合作方标识
    public static final String PARTNER_CODE     = "duiba";
    // 合作方密钥
    public static final String PARTNER_KEY      = "b2d67c33b9834f5ba69bc19f6ddd5a7b";
    // 应用app
    public static final String APP_NAME         = "tuia_h5";
    // 应用秘钥
    public static final String SECRET_KEY       = "80b1fbfce3314cb5b599038ef476a524";
    // 事件标识
    public static final String EVENT_ID         = "marketing";

    public static final String RESP_DETAIL_TYPE = "device";

    private String              apiUrl;                                                      // API请求地址
    private String              partnerCode;                                                // 合作方标识
    private String              secretKey;                                                  // API请求秘钥
    private String              eventId;                                                    // 接口调用时，用该字段区分不同
    private String              tokenId;                                                    // JS方式对接，用于关联设备指纹
    private String              blackBox;                                                   // sdk方式对接，用于关联设备指纹
    private String              respDetailType;                                            // 支持API实时返回设备或解析信息
    private String              referCust;                                                  // 网页端请求来源
    private String              eventOccurTime;                                            // 事件时间
    private String              accountLogin;                                               // 账户名
    private String              ipAddress;                                                  // IP地址
    private String              extMediaId;                                                // 媒体id
    private String              extActivityId;                                             // 活动id
    private String              extRequestid;                                               // 标识唯一的请求id
    private String              extOpenURLTime;                                            // 打开页面时间
    private String              extAdvertisingId;                                          // 广告券id
    private String              extAdvertisingexposureTime;                                // 广告曝光时间
    private String              slotId;                                                      // 广告位ID，供响应答应日志使用

    public FraudApiRequest() {
        this.apiUrl = API_URL;
        this.partnerCode = PARTNER_CODE;
        this.secretKey = SECRET_KEY;
        this.eventId = EVENT_ID;
        this.respDetailType = RESP_DETAIL_TYPE;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getPartnerCode() {
        return partnerCode;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEventId() {
        return eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getTokenId() {
        return tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getBlackBox() {
        return blackBox;
    }

    public void setBlackBox(String blackBox) {
        this.blackBox = blackBox;
    }

    public String getRespDetailType() {
        return respDetailType;
    }

    public void setRespDetailType(String respDetailType) {
        this.respDetailType = respDetailType;
    }

    public String getReferCust() {
        return referCust;
    }

    public void setReferCust(String referCust) {
        this.referCust = referCust;
    }

    public String getEventOccurTime() {
        return eventOccurTime;
    }

    public void setEventOccurTime(String eventOccurTime) {
        this.eventOccurTime = eventOccurTime;
    }

    public String getAccountLogin() {
        return accountLogin;
    }

    public void setAccountLogin(String accountLogin) {
        this.accountLogin = accountLogin;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getExtMediaId() {
        return extMediaId;
    }

    public void setExtMediaId(String extMediaId) {
        this.extMediaId = extMediaId;
    }

    public String getExtActivityId() {
        return extActivityId;
    }

    public void setExtActivityId(String extActivityId) {
        this.extActivityId = extActivityId;
    }

    public String getExtRequestid() {
        return extRequestid;
    }

    public void setExtRequestid(String extRequestid) {
        this.extRequestid = extRequestid;
    }

    public String getExtOpenURLTime() {
        return extOpenURLTime;
    }

    public void setExtOpenURLTime(String extOpenURLTime) {
        this.extOpenURLTime = extOpenURLTime;
    }

    public String getExtAdvertisingId() {
        return extAdvertisingId;
    }

    public void setExtAdvertisingId(String extAdvertisingId) {
        this.extAdvertisingId = extAdvertisingId;
    }

    public String getExtAdvertisingexposureTime() {
        return extAdvertisingexposureTime;
    }

    public void setExtAdvertisingexposureTime(String extAdvertisingexposureTime) {
        this.extAdvertisingexposureTime = extAdvertisingexposureTime;
    }

    public String getSlotId() {
        return slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }
}
