package com.duiba.tuia.youtui.web.service.impl;

import cn.com.duiba.tuia.activity.center.api.dto.PrizeDto;
import cn.com.duiba.tuia.activity.center.api.dto.RspTakeCoupon;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemotePrizeService;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteVirtualService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.duiba.tuia.youtui.web.service.BaseCacheService;
import com.duiba.tuia.youtui.web.service.PrizeService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;


/**
 * Created by Administrator on 2017/6/5.
 */
@Service
public class PrizeServiceImpl extends BaseCacheService implements PrizeService {
    @Autowired
    private RemotePrizeService remotePrizeService;

    @Autowired
    private RemoteVirtualService remoteVirtualService;


    @Override
    public PrizeDto obtainPrize(String orderId, Long prizeId, Integer num){
        DubboResult<PrizeDto> prizeDtoDubboResult = remotePrizeService.obtainPrizeNew(prizeId, orderId, num);

        if (!prizeDtoDubboResult.isSuccess()) {
            if(Objects.equals(cn.com.duiba.tuia.activity.center.api.constant.ErrorCode.E0000001.getErrorCode(),
                    prizeDtoDubboResult.getReturnCode())){
                //业务异常，属于正常异常
                logger.info("请求奖品正常失败，错误码： [{}], 失败原因： [{}]", prizeDtoDubboResult.getReturnCode(), prizeDtoDubboResult.getMsg());
            }else {
                logger.warn("请求奖品失败，错误码： [{}], 失败原因： [{}]", prizeDtoDubboResult.getReturnCode(), prizeDtoDubboResult.getMsg());
            }
            return null;
        }
        return prizeDtoDubboResult.getResult();
    }

    @Override
    public PrizeDto selectPrizeById(Long prizeId){
        DubboResult<PrizeDto> prizeDtoDubboResult = remotePrizeService.selectPrizeById(prizeId, false);
        return prizeDtoDubboResult.getResult();
    }

    @Override
    public RspTakeCoupon takeCoupon(Long prizeId) {
        return this.remoteVirtualService.takeCoupon(prizeId.toString()).getResult();
    }

    @Override
    public List<PrizeDto> selectByIds(List<Long> ids) {
        DubboResult<List<PrizeDto>> dubboResult = this.remotePrizeService.selectByIds(ids);
        return dubboResult.getResult();
    }




}
