package com.duiba.tuia.youtui.web.service.impl;

import com.duiba.tuia.youtui.web.constant.Constants;
import com.duiba.tuia.youtui.web.embed.CustomizedEmbed;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.embed.DsmBuilder;
import com.duiba.tuia.youtui.web.model.UserAccount;
import com.duiba.tuia.youtui.web.service.CustomizedEmbedService;
import com.duiba.tuia.youtui.web.service.DirectPageSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 处理定制需求埋点的service
 *
 * @author lichao 2018/3/29
 */
@Service
public class CustomizedEmbedServiceImpl implements CustomizedEmbedService {

    /**
     * 直投页来源service
     */
    @Autowired
    private DirectPageSourceService directPageSourceService;

    /**
     * 构建定制直投页传奇皮肤的埋点信息
     *
     * @param dsm      旧dsm
     * @param consumer 账户
     * @param host     host
     * @return 埋点信息
     */
    @Override
    public Map<String, String> buildChuanqiEmbed(Long pageId, String dsm, UserAccount consumer, String host) {
        Long appId = consumer.getAppId();
        String dcm = DcmBuilder.directFixedBlockBuild(pageId);
        CustomizedEmbed commonEmbed = new CustomizedEmbed(dcm, DsmBuilder.directBlockBuild(dsm, pageId), null, consumer.getUserId(), consumer.getAppId(), host, null);
        //1.继续寻宝按钮
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_continue");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_continue");
        //2.查看奖励按钮
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_show");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_show");
        //3.去换装图片1
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_2)).buildClick("st_info_click_img_go_1");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_img_go_1");
        //4.去换装按钮1
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_3)).buildClick("st_info_click_btn_go_1");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_3)).buildExposure("st_info_exposure_btn_go_1");
        //5.去换装图片2
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_4)).buildClick("st_info_click_img_go_2");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_4)).buildExposure("st_info_exposure_img_go_2");
        //6.去换装按钮2
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_5)).buildClick("st_info_click_btn_go_2");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_5)).buildExposure("st_info_exposure_btn_go_2");


        return commonEmbed.embed();
    }

    /**
     * @param pageId   页面ID
     * @param times    第几局
     * @param dsm      页面DSM
     * @param consumer 账户
     * @param host
     * @return
     */
    @Override
    public Map<String, String> buildFindDiffEmbed(Long pageId, Long times, String dsm, UserAccount consumer, String host) {
        Long appId = consumer.getAppId();

        // 构建CustomizedEmbed
        CustomizedEmbed commonEmbed = new CustomizedEmbed(null, DsmBuilder.directBlockBuild(dsm, pageId), null, consumer.getUserId(), consumer.getAppId(), host, null);

        // 构建9个关卡埋点
        for (int i = 1; i < 10; i++) {
            // 构建关卡dcm
            commonEmbed.setDcm(DcmBuilder.build(Constants.DCM.DCM_A_1002, pageId, times, i));

            // 构建关卡dpm
            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_option_" + i);
            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_option_" + i);

            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildClick("st_info_click_btn_rule_" + i);
            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_2)).buildExposure("st_info_exposure_btn_rule_" + i);

            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildClick("st_info_click_btn_checkpoint_" + i);
            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_1, Constants.DPM.DPM_D_3)).buildExposure("st_info_exposure_btn_checkpoint_" + i);

            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_fail_" + i);
            commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_2, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_fail_" + i);
        }

        // 构建通关后查看奖品埋点
        commonEmbed.setDcm(DcmBuilder.build(Constants.DCM.DCM_A_1002, pageId, 0, 0));
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildClick("st_info_click_btn_option");
        commonEmbed.setDpm(DpmBuilder.directBlockBuild(appId, Constants.DPM.DPM_C_3, Constants.DPM.DPM_D_1)).buildExposure("st_info_exposure_btn_option");

        return commonEmbed.embed();
    }
}
