package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.Scene;
import cn.com.duiba.tuia.activity.center.api.dto.ActivityPluginDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDto;

import java.util.List;
import java.util.Optional;

public interface SlotService {

    /**
     * 查询广告位下配置的可用插件
     * <p>
     * 以广告位维度缓存30s
     *
     * @param pluginIds 插件ids
     * @param slotId    广告位id
     * @return 开启，非删除的插件
     */
    List<ActivityPluginDto> getAvailablePlugin(List<Long> pluginIds, Long slotId);

    /**
     * 根据广告位id查询信息
     *
     * @param slotId 广告位id
     * @return
     */
    Optional<SlotDto> getSlot(Long slotId);

    /**
     * 查询广告位的标签id
     *
     * @param slotId 广告位id
     * @return list id
     */
    List<String> getSlotIdTags(Long slotId);

    /**
     * 广告位 区域屏蔽
     *
     * @param slotDto 广告位配置
     * @param ip      ip地址
     * @param scene   场景
     * @return true：要投放,false:被屏蔽
     */
    boolean ipFilter(SlotDto slotDto, String ip, Scene scene);

    /**
     * 根据ip查询区域编码
     * @param ip 地址
     */
    Long findRegionByIp(String ip);


}
