/**
 * Project Name:tuia-youtui-web<br>
 * File Name:GuidePageService.java<br>
 * Package Name:com.duiba.tuia.youtui.web.service<br>
 * Date:2017年3月7日下午7:25:22<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.tuia.activity.center.api.dto.*;
import com.duiba.tuia.youtui.web.exception.ActivityException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName: GuidePageService <br/>
 * 引导页service date: 2017年3月7日 下午7:25:22 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public interface GuidePageService {

    /**
     * 获取引导页配置.
     *
     * @param id the id
     * @return the guide page
     * @throws ActivityException the activity exception
     */
    GuidePageDto getGuidePage(Long id) throws ActivityException;

    /**
     * 获取引导页皮肤.
     *
     * @param id the id
     * @return the guide page skin
     * @throws ActivityException the activity exception
     */
    GuidePageSkinDto getGuidePageSkin(Long id) throws ActivityException;

    
    /**
     * 获取最新的可用活动中心的ID.
     *
     * @return the act center id
     * @throws ActivityException the activity exception
     */
    Long getActCenterId() throws ActivityException;

    /**
     * 获取直投页id
     * @param appId 媒体id
     * @param probDto 概率
     * @param pageType 页面类型
     * @return 直投页id
     * @throws ActivityException
     */
    Long getGuidePageId(Long appId, ProbDto probDto, PageType pageType) throws ActivityException;

    /**
     *
     * 获取出的直投页
     * @param appId appId（过滤媒体定向用）
     * @param probDto 概率（根据概率出）
     * @return 直投页id
     */
    Long getDirectPageId(Long appId, ProbDto probDto) throws ActivityException;

    /**
     * 获取直投页区块
     * @param pageId 直投页id
     * @return list GuidePageBlockDto
     */
    List<GuidePageBlockDto> getDirectBlocks(Long pageId);

    /**
     * 批量获取引导页
     * @param ids id list
     * @return dto list
     */
    List<GuidePageDto> getGuidePages(List<Long> ids);

    /**
     * 批量查询引导页
     * 从缓存中获取
     * @param ids
     * @return
     */
    List<GuidePageDto> getGuidePagesFromCache(List<Long> ids);

    /**
     * 通过pageId获取直投页零钱奖项
     *
     * @param pageId
     * @return
     */
    GuidePageMoneyConfigDto getGuidePageMoneyConfigDto(Long pageId);

    /**
     * 批量查询主会场关联活动的所有标签
     * @param ids 主会场id
     * @return
     */
    Map<Long, Set<Long>> getMainMeetActivityTag(List<Long> ids);

    /**
     * 批量查询主会场关联的活动id list
     * @param ids 主会场ids
     * @return
     */
    List<Long> getActivityIdByMainMeetIds(List<Long> ids);
    

}
