package com.duiba.tuia.youtui.web.service;

import cn.com.duiba.tuia.activity.center.api.cache.CacheSpace;
import cn.com.duiba.tuia.activity.center.api.dto.BetGameHistoryDto;
import cn.com.duiba.tuia.activity.center.api.dto.BetGameResultDto;
import cn.com.duiba.tuia.activity.center.api.dto.BetGameTimeDto;
import cn.com.duiba.tuia.activity.center.api.dto.GameConfigDto;
import cn.com.duiba.tuia.activity.center.api.remoteservice.RemoteBetGameService;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.embed.GameEmbed;
import com.duiba.tuia.youtui.web.model.rsp.BetGameResult;
import com.duiba.tuia.youtui.web.model.rsp.BetHistoryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

import static com.duiba.tuia.youtui.web.constant.Constants.DCM.DCM_C_0;
import static com.duiba.tuia.youtui.web.constant.Constants.DCM.DCM_D_0;
import static com.duiba.tuia.youtui.web.constant.Constants.DPM.*;

/**
 * @author liuqingsong
 * @date 2018-02-26
 */
@Service
public class BetGameService extends BaseService {

    @Autowired
    private RemoteBetGameService remoteBetGameService;

    @Autowired
    private GameCacheService gameCacheService;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public BetHistoryResult getHistoryResult(Long gameId) {
        BetGameHistoryDto betGameHistoryDto = remoteBetGameService.getHistoryResult(gameId);
        BetHistoryResult betHistoryResult = new BetHistoryResult();
        betHistoryResult.setLastResult(betGameHistoryDto.getLastResult());
        betHistoryResult.setNowResult(betGameHistoryDto.getNowResult());
        return betHistoryResult;
    }

    public BetGameResult getResult(Long gameId, Long userId) {

        BetGameResultDto betGameResultDto = remoteBetGameService.getResult(gameId, userId);
        if (betGameResultDto == null) {
            BetGameResult result = new BetGameResult();
            result.setBetId(-1);
            return result;
        }


        BetGameResult betGameResult = new BetGameResult();
        betGameResult.setBetId(betGameResultDto.getBetResult());
        betGameResult.setRewardMoney(betGameResultDto.getRewardAmount());
        betGameResult.setUserName(betGameResultDto.getUserName());
        betGameResult.setMostRewardMoney(betGameResultDto.getMostRewardAmount());

        BetGameTimeDto betGameTimeDto = remoteBetGameService.getNowTime(gameId);
        Long time = ((System.currentTimeMillis() - betGameTimeDto.getRunTime()) / 1000) % 36;
        if (time <= 30) {
            time = 30 - time;
        } else {
            time = 35 - time + 30;
        }
        betGameResult.setTime(time);
        betGameResult.setPerId(betGameTimeDto.getPerId());
        return betGameResult;
    }

    public JSONObject getBetEmbed(Long gameId, Long appId, Long userId, String host, String slotId, Long directId) {
        String dcm2 = "";
        GameConfigDto gameConfigDto = gameCacheService.getGameConfigDto(gameId);
        if (gameConfigDto != null && gameConfigDto.getIsDeleted() == 0) {
            dcm2 = DcmBuilder.directFixedBlockBuild(gameConfigDto.getExtInfo().getPageId());
        }
        JSONObject embed = new JSONObject();
        String dcm = DcmBuilder.gameBuild(gameId, DCM_C_0, DCM_D_0);
        String dsm;
        if (directId == -1) {
            dsm = "1." + slotId + ".0.0";
        } else {
            dsm = "1." + slotId + ".3." + directId;
        }
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_1), userId, appId, host,null).buildBetA(embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_2), userId, appId, host,null).buildBetB(embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_3), userId, appId, host,null).buildBetC
                (embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_4), userId, appId, host,null).buildBetD
                (embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_5), userId, appId, host,null).buildBetGameRule
                (embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_6), userId, appId, host,null).buildBetModeChange(embed);


        new GameEmbed(dcm2, dsm, DpmBuilder.gameBuild(appId, DPM_C_2, DPM_D_7), userId, appId, host,null).buildBetObtainAmount(embed);


        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_3, DPM_D_1), userId, appId, host,null).buildBetGameOver(embed);
        new GameEmbed(dcm, dsm, DpmBuilder.gameBuild(appId, DPM_C_4, DPM_D_1), userId, appId, host,null).buildBetGameRuleClose(embed);
        return embed;
    }

    public String getData(Long gameId) {
        Long earn = stringRedisTemplate.opsForValue().increment(CacheSpace.BET_GAME_TOTAL_EARN.generatorKey(gameId), 0L);
        Long consume = stringRedisTemplate.opsForValue().increment(CacheSpace.BET_GAME_TOTAL_CONSUME.generatorKey(gameId), 0L);
        return "earn=" + earn + " and consume = " + consume;
    }
}
