package com.duiba.tuia.youtui.web.model.toutiao;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 头条请求-Adslot对象
 *
 * Created by xuefeng on 2017/10/31.
 */
public class Adslot implements Serializable {
    private static final long serialVersionUID = 5024403592598090228L;

    private String id;
    private Integer adtype;//广告类型banner=1；插屏=2；开屏广告=3；信息流=5
    private Integer pos;//广告位位置，顶部=1；底部=2；信息流内=3；中部=4；全屏=5；
    @JsonProperty("accepted_size")
    private List<AcceptedSize> acceptedSize;
    @JsonProperty("accepted_creative_type")
    private Integer acceptedCreativeType;//可接受创意类型，文字=1；静态图片=2；图文=6；
    @JsonProperty("accepted_interaction_type")
    private Integer acceptedInteractionType;//支持交互类型，浏览器打开=2；应用内打开=3；下载应用=4
    @JsonProperty("minimum_cpm")
    private long minimumCpm;
    @JsonProperty("ad_count")
    private Integer adCount;
    @JsonProperty("is_origin_ad")
    private Boolean isOriginAd;

    public static final Integer AD_TYPE_BANNER = 1;//banner
    public static final Integer AD_TYPE_INSERT = 2;//插屏
    public static final Integer AD_TYPE_OPEN = 3;//开屏
    public static final Integer AD_TYPE_FLOW = 5;//信息流

    public Adslot() {
        acceptedSize = new ArrayList<>();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getAdtype() {
        return adtype;
    }

    public void setAdtype(Integer adtype) {
        this.adtype = adtype;
    }

    public Integer getPos() {
        return pos;
    }

    public void setPos(Integer pos) {
        this.pos = pos;
    }

    public List<AcceptedSize> getAcceptedSize() {
        return acceptedSize;
    }

    public void setAcceptedSize(List<AcceptedSize> acceptedSize) {
        this.acceptedSize = acceptedSize;
    }

    public Integer getAcceptedCreativeType() {
        return acceptedCreativeType;
    }

    public void setAcceptedCreativeType(Integer acceptedCreativeType) {
        this.acceptedCreativeType = acceptedCreativeType;
    }

    public Integer getAcceptedInteractionType() {
        return acceptedInteractionType;
    }

    public void setAcceptedInteractionType(Integer acceptedInteractionType) {
        this.acceptedInteractionType = acceptedInteractionType;
    }

    public long getMinimumCpm() {
        return minimumCpm;
    }

    public void setMinimumCpm(long minimumCpm) {
        this.minimumCpm = minimumCpm;
    }

    public Integer getAdCount() {
        return adCount;
    }

    public void setAdCount(Integer adCount) {
        this.adCount = adCount;
    }

    public Boolean getOriginAd() {
        return isOriginAd;
    }

    public void setOriginAd(Boolean originAd) {
        isOriginAd = originAd;
    }

    public void setAcceptedSize(Integer width, Integer height) {
        AcceptedSize tmp = new AcceptedSize();
        tmp.setWidth(width);
        tmp.setHeight(height);
        this.acceptedSize.add(tmp);
    }

    public static class AcceptedSize implements Serializable {
        private static final long serialVersionUID = 602529883264641753L;

        private Integer width;
        private Integer height;

        public Integer getWidth() {
            return width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }
    }
}
