/**
 * 
 */
package com.duiba.tuia.youtui.web.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
@ApiModel
public class PageQueryReq {

    /** 每页10条记录. */
    public static final int PAGE_SIZE_50     = 50;
    
    /** 起始记录数. */
    private Integer         rowStart         = 0;

    /** 当前页. */
    private Integer         currentPage      = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    @ApiModelProperty(value = "每页记录数", required = false)
    private Integer         pageSize;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order            = "desc";

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
