package com.duiba.tuia.youtui.web.model.req;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * 
 * ClassName: InnerLogReq <br/>
 * Function: 日志接口参数. <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
@ApiModel
public class InnerLogReq {

    @NotNull(message = "json字段不能为空")
    private String  json;
    @NotNull(message = "type字段不能为空")
    private Integer type;

    public String getJson() {
        return StringEscapeUtils.unescapeHtml3(json);
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

}
