package com.duiba.tuia.youtui.web.model.direct;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;
import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;

/**
 * Created by xuefeng on 2018/1/22.
 */
public class EmbeddedPluginBlock extends Block {

    private Long embeddedPluginId;

    public Long getEmbeddedPluginId() {
        return embeddedPluginId;
    }

    public void setEmbeddedPluginId(Long embeddedPluginId) {
        this.embeddedPluginId = embeddedPluginId;
    }

    public EmbeddedPluginBlock(GuidePageBlockDto dto) {
        super(dto);
    }

    public EmbeddedPluginBlock(GuidePageBlockDto dto, Long embeddedPluginId) {
        super(dto);
        this.embeddedPluginId = embeddedPluginId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host,Long directPage) {
        super.setDcm(DcmBuilder.pluginBuild(embeddedPluginId, super.getPageId(), PageType.DIRECT.getCode()));
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        super.setDsm(dsm);
        DirectEmbed directEmbed = new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(directEmbed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        super.setUrl("");
    }
}
