package com.duiba.tuia.youtui.web.model.direct;

import com.duiba.tuia.youtui.web.embed.DcmBuilder;
import com.duiba.tuia.youtui.web.embed.DirectEmbed;
import com.duiba.tuia.youtui.web.embed.DpmBuilder;
import com.duiba.tuia.youtui.web.model.ActivityForActCenterVO;
import com.duiba.tuia.youtui.web.model.req.DirectPageReq;
import com.duiba.tuia.youtui.web.model.req.IndexReq;
import com.duiba.tuia.youtui.web.tool.PathUtil;

import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import cn.com.duiba.tuia.activity.center.api.dto.GuidePageBlockDto;

/**
 * 直投页活动区块 Created by wubo on 2017/8/31.
 */
public class ActivityBlock extends Block {

    /**
     * 活动id
     */
    private Long             activityId;
    /**
     * 活动标题
     */
    private String           title;
    /**
     * 活动banner图
     */
    private String           bannerUrl;
    /**
     * 列表图
     */
    private String           listUrl;
    /**
     * 推荐图
     */
    private String           recommendUrl;


    public ActivityBlock(GuidePageBlockDto dto, ActivityForActCenterVO activity) {
        super(dto);
        this.activityId = activity.getId();
        this.title = activity.getTitle();
        this.bannerUrl = activity.getBannerUrl();
        this.listUrl = activity.getListUrl();
        this.recommendUrl = activity.getRecommendUrl();
    }

    public ActivityBlock(GuidePageBlockDto dto, Long activityId) {
        super(dto);
        this.activityId = activityId;
    }

    @Override
    public void buildEmbed(String dsm, int regionNum, int blockNum, Long consumerId, Long appId, String host,Long directPage) {
        super.setDcm(DcmBuilder.directActivityBlockBuild(activityId, super.getPageId()));
        super.setDpm(DpmBuilder.directBlockBuild(appId, regionNum, blockNum));
        super.setDsm(dsm);
        DirectEmbed directEmbed = new DirectEmbed(super.getDcm(), dsm, super.getDpm(), consumerId, appId, host,directPage);
        super.setEmbedInfo(directEmbed.buildAdvertEmbed());
    }

    @Override
    public void buildUrl(DirectPageReq req) {
        IndexReq indexReq = new IndexReq();
        indexReq.setId(super.getPageId());
        indexReq.setAppKey(req.getAppKey());
        indexReq.setLogin(req.getLogin());
        indexReq.setSlotId(req.getSlotId());
        indexReq.setDeviceId(req.getDeviceId());
        indexReq.setDcm(super.getDcm());
        indexReq.setDsm(super.getDsm());
        indexReq.setDpm(super.getDpm());
        indexReq.setHost(req.getHost());
        super.setUrl(PathUtil.getActivityUrl(activityId, indexReq, super.getPageId(), PageType.DIRECT.getCode()));
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getListUrl() {
        return listUrl;
    }

    public void setListUrl(String listUrl) {
        this.listUrl = listUrl;
    }

    public String getRecommendUrl() {
        return recommendUrl;
    }

    public void setRecommendUrl(String recommendUrl) {
        this.recommendUrl = recommendUrl;
    }

}
